/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.cache;

import biz.gabrys.lesscss.extended.compiler.cache.CacheException;
import biz.gabrys.lesscss.extended.compiler.cache.DeletableCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.storage.DataStorage;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullCacheImpl
implements FullCache,
DeletableCache {
    protected DataStorage storage;

    public FullCacheImpl(DataStorage storage) {
        ParameterUtils.verifyNotNull("data storage", storage);
        this.storage = storage;
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    @Override
    public void saveSourceModificationDate(LessSource source, Date modificationDate) {
        this.storage.put(this.createFileName(EntryType.MODIFICATION_DATE, source), String.valueOf(modificationDate.getTime()));
    }

    @Override
    public boolean hasSourceModificationDate(LessSource source) {
        return this.storage.hasData(this.createFileName(EntryType.MODIFICATION_DATE, source));
    }

    @Override
    public Date getSourceModificationDate(LessSource source) {
        String modificationDate = this.storage.getText(this.createFileName(EntryType.MODIFICATION_DATE, source));
        try {
            return new Date(Long.parseLong(modificationDate));
        }
        catch (NumberFormatException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void saveSourceImports(LessSource source, List<String> imports) {
        this.storage.put(this.createFileName(EntryType.IMPORTS_LIST, source), imports);
    }

    @Override
    public boolean hasSourceImports(LessSource source) {
        return this.storage.hasData(this.createFileName(EntryType.IMPORTS_LIST, source));
    }

    @Override
    public List<String> getSourceImports(LessSource source) {
        return this.storage.getLines(this.createFileName(EntryType.IMPORTS_LIST, source));
    }

    @Override
    public void saveSourceCode(LessSource source, String sourceCode) {
        this.storage.put(this.createFileName(EntryType.SOURCE_CODE, source), sourceCode);
    }

    @Override
    public boolean hasSourceCode(LessSource source) {
        return this.storage.hasData(this.createFileName(EntryType.SOURCE_CODE, source));
    }

    @Override
    public File getSourceFile(LessSource source) {
        return this.storage.getFile(this.createFileName(EntryType.SOURCE_CODE, source));
    }

    @Override
    public String getSourceRelativePath(LessSource source) {
        return this.createFileName(EntryType.SOURCE_CODE, source);
    }

    @Override
    public void saveCompilationDate(LessSource source, Date compilationDate) {
        this.storage.put(this.createFileName(EntryType.COMPILATION_DATE, source), String.valueOf(compilationDate.getTime()));
    }

    @Override
    public boolean hasCompilationDate(LessSource source) {
        return this.storage.hasData(this.createFileName(EntryType.COMPILATION_DATE, source));
    }

    @Override
    public Date getCompilationDate(LessSource source) {
        String compilationDate = this.storage.getText(this.createFileName(EntryType.COMPILATION_DATE, source));
        try {
            return new Date(Long.parseLong(compilationDate));
        }
        catch (NumberFormatException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void saveCompiledCode(LessSource source, String compiledCode) {
        this.storage.put(this.createFileName(EntryType.COMPILED_CODE, source), compiledCode);
    }

    @Override
    public boolean hasCompiledCode(LessSource source) {
        return this.storage.hasData(this.createFileName(EntryType.COMPILED_CODE, source));
    }

    @Override
    public String getCompiledCode(LessSource source) {
        return this.storage.getText(this.createFileName(EntryType.COMPILED_CODE, source));
    }

    @Override
    public void delete(LessSource source) {
        for (EntryType type : EntryType.values()) {
            this.storage.delete(this.createFileName(type, source));
        }
    }

    @Override
    public void deleteAll() {
        this.storage.deleteAll();
    }

    protected String createFileName(EntryType type, LessSource source) {
        int hashCode;
        String path = source.getPath();
        int index = path.replace('\\', '/').lastIndexOf(47);
        StringBuilder fileName = new StringBuilder(75);
        if (index > 0) {
            fileName.append(path.substring(index + 1));
            fileName.append('-');
        }
        if ((hashCode = path.hashCode()) < 0) {
            fileName.append('n');
            fileName.append(Math.abs(hashCode));
        } else {
            fileName.append('p');
            fileName.append(hashCode);
        }
        fileName.append(type.getExtension());
        return fileName.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EntryType {
        MODIFICATION_DATE,
        IMPORTS_LIST,
        SOURCE_CODE,
        COMPILATION_DATE,
        COMPILED_CODE;

        private final String extension = '.' + this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');

        public String getExtension() {
            return this.extension;
        }
    }
}

