/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.processor;

import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceAlwaysExpiredChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.SourceTreePreparationProcessor;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolverImpl;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class SourceTreePreparationProcessorBuilder {
    private final SourceModificationDateCache datesCache;
    private final SourceImportsCache importsCache;
    private SourceExpirationChecker expirationChecker;
    private LessImportResolver importResolver;
    private SourceFactory sourceFactory;

    public SourceTreePreparationProcessorBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("cache", cache);
        this.datesCache = cache;
        this.importsCache = cache;
    }

    public SourceTreePreparationProcessorBuilder(SourceModificationDateCache datesCache, SourceImportsCache importsCache) {
        ParameterUtils.verifyNotNull("dates cache", datesCache);
        ParameterUtils.verifyNotNull("imports cache", importsCache);
        this.datesCache = datesCache;
        this.importsCache = importsCache;
    }

    public SourceTreePreparationProcessorBuilder withExpirationChecker(SourceExpirationChecker expirationChecker) {
        this.expirationChecker = expirationChecker;
        return this;
    }

    public SourceTreePreparationProcessorBuilder withImportResolver(LessImportResolver importResolver) {
        this.importResolver = importResolver;
        return this;
    }

    public SourceTreePreparationProcessorBuilder withSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
        return this;
    }

    public SourceTreePreparationProcessor create() {
        SourceExpirationChecker checker = this.createExpirationChecker();
        LessImportResolver resolver = this.createImportResolver();
        SourceFactory factory = this.createSourceFactory();
        return new SourceTreePreparationProcessor(checker, this.datesCache, this.importsCache, resolver, factory);
    }

    SourceExpirationChecker createExpirationChecker() {
        return this.expirationChecker != null ? this.expirationChecker : new SourceAlwaysExpiredChecker();
    }

    LessImportResolver createImportResolver() {
        return this.importResolver != null ? this.importResolver : new LessImportResolverImpl();
    }

    SourceFactory createSourceFactory() {
        return this.sourceFactory != null ? this.sourceFactory : this.createSourceFactoryFromBuilder(new SourceFactoryBuilder());
    }

    SourceFactory createSourceFactoryFromBuilder(SourceFactoryBuilder builder) {
        return builder.withStandard().create();
    }
}

