/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.ClasspathSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.ConcreteSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.FtpSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.HttpSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.LocalSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryImpl;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFactoryBuilder {
    private final Map<Class<?>, ConcreteSourceFactory<? extends LessSource>> factories;

    public SourceFactoryBuilder() {
        this(new LinkedHashMap());
    }

    SourceFactoryBuilder(Map<Class<?>, ConcreteSourceFactory<? extends LessSource>> factories) {
        this.factories = factories;
    }

    public SourceFactoryBuilder withStandard() {
        return this.withHttp().withFtp().withLocal();
    }

    public SourceFactoryBuilder withLocal() {
        if (!this.factories.containsKey(LocalSourceFactory.class)) {
            this.factories.put(LocalSourceFactory.class, new LocalSourceFactory());
        }
        return this;
    }

    public SourceFactoryBuilder withHttp() {
        if (!this.factories.containsKey(HttpSourceFactory.class)) {
            this.factories.put(HttpSourceFactory.class, new HttpSourceFactory());
        }
        return this;
    }

    public SourceFactoryBuilder withFtp() {
        if (!this.factories.containsKey(FtpSourceFactory.class)) {
            this.factories.put(FtpSourceFactory.class, new FtpSourceFactory());
        }
        return this;
    }

    public SourceFactoryBuilder withClasspath() {
        if (!this.factories.containsKey(ClasspathSourceFactory.class)) {
            this.factories.put(ClasspathSourceFactory.class, new ClasspathSourceFactory());
        }
        return this;
    }

    public SourceFactoryBuilder withCustom(ConcreteSourceFactory<? extends LessSource> factory) {
        ParameterUtils.verifyNotNull("factory", factory);
        if (!this.factories.containsKey(factory.getClass())) {
            this.factories.put(factory.getClass(), factory);
        }
        return this;
    }

    public SourceFactoryImpl create() {
        return new SourceFactoryImpl(this.factories.values());
    }
}

