/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPrivateKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPSecretKey {
    SecretKeyPacket secret;
    TrustPacket trust;
    List keySigs;
    List ids;
    List idTrusts;
    List idSigs;
    PGPPublicKey pub;
    List subSigs = null;

    private PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, List list, List list2, List list3, List list4, PGPPublicKey pGPPublicKey) {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.pub = pGPPublicKey;
    }

    private PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, List list, PGPPublicKey pGPPublicKey) {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.subSigs = list;
        this.pub = pGPPublicKey;
    }

    PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, List list, List list2, List list3, List list4) throws IOException {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.pub = new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list, list2, list3, list4);
    }

    PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, List list) throws IOException {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.subSigs = list;
        this.pub = new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, list);
    }

    PGPSecretKey(PGPKeyPair pGPKeyPair, TrustPacket trustPacket, List list, int n, char[] cArray, boolean bl, SecureRandom secureRandom, String string) throws PGPException, NoSuchProviderException {
        this(pGPKeyPair, n, cArray, bl, secureRandom, string);
        this.secret = new SecretSubkeyPacket(this.secret.getPublicKeyPacket(), this.secret.getEncAlgorithm(), this.secret.getS2KUsage(), this.secret.getS2K(), this.secret.getIV(), this.secret.getSecretKeyData());
        this.trust = trustPacket;
        this.subSigs = list;
        this.pub = new PGPPublicKey(pGPKeyPair.getPublicKey(), trustPacket, list);
    }

    PGPSecretKey(PGPKeyPair pGPKeyPair, int n, char[] cArray, boolean bl, SecureRandom secureRandom, String string) throws PGPException, NoSuchProviderException {
        Object object;
        Object object2;
        BCPGObject bCPGObject;
        Object object3;
        PublicKeyPacket publicKeyPacket = pGPKeyPair.getPublicKey().publicPk;
        switch (pGPKeyPair.getPublicKey().getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                object3 = (RSAPrivateCrtKey)pGPKeyPair.getPrivateKey().getKey();
                bCPGObject = new RSASecretBCPGKey(object3.getPrivateExponent(), object3.getPrimeP(), object3.getPrimeQ());
                break;
            }
            case 17: {
                object2 = (DSAPrivateKey)pGPKeyPair.getPrivateKey().getKey();
                bCPGObject = new DSASecretBCPGKey(object2.getX());
                break;
            }
            case 16: 
            case 20: {
                object = (ElGamalPrivateKey)pGPKeyPair.getPrivateKey().getKey();
                bCPGObject = new ElGamalSecretBCPGKey(object.getX());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        object3 = PGPUtil.getSymmetricCipherName(n);
        object2 = null;
        if (object3 != null) {
            try {
                object2 = Cipher.getInstance((String)object3 + "/CFB/NoPadding", string);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw noSuchProviderException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        try {
            object = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)object);
            bCPGOutputStream.writeObject(bCPGObject);
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            bCPGOutputStream.write(PGPSecretKey.checksum(bl, byArray, byArray.length));
            if (object2 != null) {
                byte[] byArray2 = new byte[8];
                secureRandom.nextBytes(byArray2);
                S2K s2K = new S2K(2, byArray2, 96);
                SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(n, s2K, cArray, string);
                ((Cipher)object2).init(1, (Key)secretKey, secureRandom);
                byArray2 = ((Cipher)object2).getIV();
                byte[] byArray3 = ((Cipher)object2).doFinal(((ByteArrayOutputStream)object).toByteArray());
                this.secret = bl ? new SecretKeyPacket(publicKeyPacket, n, 254, s2K, byArray2, byArray3) : new SecretKeyPacket(publicKeyPacket, n, 255, s2K, byArray2, byArray3);
                this.trust = null;
            } else {
                this.secret = new SecretKeyPacket(publicKeyPacket, n, null, null, ((ByteArrayOutputStream)object).toByteArray());
                this.trust = null;
            }
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception encrypting key", exception);
        }
        this.keySigs = new ArrayList();
    }

    public PGPSecretKey(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, pGPKeyPair, string, n2, cArray, false, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2);
    }

    public PGPSecretKey(int n, PGPKeyPair pGPKeyPair, String string, int n2, char[] cArray, boolean bl, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(pGPKeyPair, n2, cArray, bl, secureRandom, string2);
        try {
            this.trust = null;
            this.ids = new ArrayList();
            this.ids.add(string);
            this.idTrusts = new ArrayList();
            this.idTrusts.add(null);
            this.idSigs = new ArrayList();
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPKeyPair.getPublicKey().getAlgorithm(), 2, string2);
            pGPSignatureGenerator.initSign(n, pGPKeyPair.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(string, pGPKeyPair.getPublicKey());
            this.pub = PGPPublicKey.addCertification(pGPKeyPair.getPublicKey(), string, pGPSignature);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignature);
            this.idSigs.add(arrayList);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception encrypting key", exception);
        }
    }

    public PGPSecretKey(int n, int n2, PublicKey publicKey, PrivateKey privateKey, Date date, String string, int n3, char[] cArray, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, new PGPKeyPair(n2, publicKey, privateKey, date, string2), string, n3, cArray, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2);
    }

    public PGPSecretKey(int n, int n2, PublicKey publicKey, PrivateKey privateKey, Date date, String string, int n3, char[] cArray, boolean bl, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        this(n, new PGPKeyPair(n2, publicKey, privateKey, date, string2), string, n3, cArray, bl, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, secureRandom, string2);
    }

    public boolean isSigningKey() {
        int n = this.pub.getAlgorithm();
        return n == 1 || n == 3 || n == 17 || n == 19 || n == 20;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractKeyData(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        String string2 = PGPUtil.getSymmetricCipherName(this.secret.getEncAlgorithm());
        Cipher cipher = null;
        if (string2 != null) {
            try {
                cipher = Cipher.getInstance(string2 + "/CFB/NoPadding", string);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw noSuchProviderException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        byte[] byArray = this.secret.getSecretKeyData();
        byte[] byArray2 = null;
        try {
            if (cipher == null) return byArray;
            try {
                int n;
                int n2;
                if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(this.secret.getIV());
                    SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), cArray, string);
                    cipher.init(2, (Key)secretKey, ivParameterSpec);
                    byArray2 = cipher.doFinal(byArray, 0, byArray.length);
                    boolean bl = this.secret.getS2KUsage() == 254;
                    byte[] byArray3 = PGPSecretKey.checksum(bl, byArray2, bl ? byArray2.length - 20 : byArray2.length - 2);
                    int n3 = 0;
                    while (n3 != byArray3.length) {
                        if (byArray3[n3] != byArray2[byArray2.length - byArray3.length + n3]) {
                            throw new PGPException("checksum mismatch at " + n3 + " of " + byArray3.length);
                        }
                        ++n3;
                    }
                    return byArray2;
                }
                SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), cArray, string);
                byArray2 = new byte[byArray.length];
                byte[] byArray4 = new byte[this.secret.getIV().length];
                System.arraycopy(this.secret.getIV(), 0, byArray4, 0, byArray4.length);
                int n4 = 0;
                for (n2 = 0; n2 != 4; ++n2) {
                    cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray4));
                    n = ((byArray[n4] << 8 | byArray[n4 + 1] & 0xFF) + 7) / 8;
                    byArray2[n4] = byArray[n4];
                    byArray2[n4 + 1] = byArray[n4 + 1];
                    cipher.doFinal(byArray, n4 + 2, n, byArray2, n4 + 2);
                    n4 += 2 + n;
                    if (n2 == 3) continue;
                    System.arraycopy(byArray, n4 - byArray4.length, byArray4, 0, byArray4.length);
                }
                n2 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                n = 0;
                for (int i = 0; i < byArray2.length - 2; ++i) {
                    n += byArray2[i] & 0xFF;
                }
                if ((n &= 0xFFFF) == n2) return byArray2;
                throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(n2) + " found " + Integer.toHexString(n));
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception decrypting key", exception);
            }
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PGPPrivateKey extractPrivateKey(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        byte[] byArray = this.secret.getSecretKeyData();
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        PublicKeyPacket publicKeyPacket = this.secret.getPublicKeyPacket();
        try {
            byte[] byArray2 = this.extractKeyData(cArray, string);
            BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray2));
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = new RSASecretBCPGKey(bCPGInputStream);
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", string);
                    return new PGPPrivateKey(keyFactory.generatePrivate(rSAPrivateCrtKeySpec), this.getKeyID());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = new DSASecretBCPGKey(bCPGInputStream);
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA", string);
                    return new PGPPrivateKey(keyFactory.generatePrivate(dSAPrivateKeySpec), this.getKeyID());
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = new ElGamalSecretBCPGKey(bCPGInputStream);
                    ElGamalPrivateKeySpec elGamalPrivateKeySpec = new ElGamalPrivateKeySpec(elGamalSecretBCPGKey.getX(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", string);
                    return new PGPPrivateKey(keyFactory.generatePrivate((KeySpec)elGamalPrivateKeySpec), this.getKeyID());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    private static byte[] checksum(boolean bl, byte[] byArray, int n) throws PGPException {
        if (bl) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(byArray, 0, n);
                return messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PGPException("Can't find SHA-1", noSuchAlgorithmException);
            }
        }
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            n2 += byArray[i] & 0xFF;
        }
        byte[] byArray2 = new byte[]{(byte)(n2 >> 8), (byte)n2};
        return byArray2;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.secret);
        if (this.trust != null) {
            bCPGOutputStream.writePacket(this.trust);
        }
        if (this.subSigs == null) {
            int n;
            for (n = 0; n != this.keySigs.size(); ++n) {
                ((PGPSignature)this.keySigs.get(n)).encode(bCPGOutputStream);
            }
            for (n = 0; n != this.ids.size(); ++n) {
                Object object;
                if (this.ids.get(n) instanceof String) {
                    object = (String)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserIDPacket((String)object));
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (this.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((ContainedPacket)this.idTrusts.get(n));
                }
                object = (ArrayList)this.idSigs.get(n);
                for (int i = 0; i != object.size(); ++i) {
                    ((PGPSignature)object.get(i)).encode(bCPGOutputStream);
                }
            }
        } else {
            for (int i = 0; i != this.subSigs.size(); ++i) {
                ((PGPSignature)this.subSigs.get(i)).encode(bCPGOutputStream);
            }
        }
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey pGPSecretKey, char[] cArray, char[] cArray2, int n, SecureRandom secureRandom, String string) throws PGPException, NoSuchProviderException {
        Object object;
        byte[] byArray = pGPSecretKey.extractKeyData(cArray, string);
        int n2 = pGPSecretKey.secret.getS2KUsage();
        byte[] byArray2 = null;
        S2K s2K = null;
        byte[] byArray3 = null;
        if (n == 0) {
            n2 = 0;
            if (pGPSecretKey.secret.getS2KUsage() == 254) {
                byArray3 = new byte[byArray.length - 18];
                System.arraycopy(byArray, 0, byArray3, 0, byArray3.length - 2);
                object = PGPSecretKey.checksum(false, byArray3, byArray3.length - 2);
                byArray3[byArray3.length - 2] = (byte)object[0];
                byArray3[byArray3.length - 1] = (byte)object[1];
            } else {
                byArray3 = byArray;
            }
        } else {
            object = null;
            String string2 = PGPUtil.getSymmetricCipherName(n);
            try {
                object = Cipher.getInstance(string2 + "/CFB/NoPadding", string);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw noSuchProviderException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
            byArray2 = new byte[8];
            secureRandom.nextBytes(byArray2);
            s2K = new S2K(2, byArray2, 96);
            try {
                SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(n, s2K, cArray2, string);
                ((Cipher)object).init(1, (Key)secretKey, secureRandom);
                byArray2 = ((Cipher)object).getIV();
                byArray3 = ((Cipher)object).doFinal(byArray);
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception encrypting key", exception);
            }
        }
        object = null;
        object = pGPSecretKey.secret instanceof SecretSubkeyPacket ? new SecretSubkeyPacket(pGPSecretKey.secret.getPublicKeyPacket(), n, n2, s2K, byArray2, byArray3) : new SecretKeyPacket(pGPSecretKey.secret.getPublicKeyPacket(), n, n2, s2K, byArray2, byArray3);
        if (pGPSecretKey.subSigs == null) {
            return new PGPSecretKey((SecretKeyPacket)object, pGPSecretKey.trust, pGPSecretKey.keySigs, pGPSecretKey.ids, pGPSecretKey.idTrusts, pGPSecretKey.idSigs, pGPSecretKey.pub);
        }
        return new PGPSecretKey((SecretKeyPacket)object, pGPSecretKey.trust, pGPSecretKey.subSigs, pGPSecretKey.pub);
    }
}

