/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class SignerAttribute
extends ASN1Encodable {
    private ASN1Sequence claimedAttributes;
    private AttributeCertificate certifiedAttributes;

    private SignerAttribute(Object object) {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)object;
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(0);
        if (dERTaggedObject.getTagNo() == 0) {
            this.claimedAttributes = ASN1Sequence.getInstance(dERTaggedObject, true);
        } else if (dERTaggedObject.getTagNo() == 1) {
            this.certifiedAttributes = AttributeCertificate.getInstance(dERTaggedObject);
        } else {
            throw new IllegalArgumentException("illegal tag.");
        }
    }

    public SignerAttribute(ASN1Sequence aSN1Sequence) {
        this.claimedAttributes = aSN1Sequence;
    }

    public SignerAttribute(AttributeCertificate attributeCertificate) {
        this.certifiedAttributes = attributeCertificate;
    }

    public AttributeCertificate getCertifiedAttributes() {
        return this.certifiedAttributes;
    }

    public ASN1Sequence getClaimedAttributes() {
        return this.claimedAttributes;
    }

    public static SignerAttribute getInstance(Object object) {
        if (object == null || object instanceof SignerAttribute) {
            return (SignerAttribute)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerAttribute(object);
        }
        throw new IllegalArgumentException("unknown object in 'SignerAttribute' factory: " + object.getClass().getName() + ".");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.claimedAttributes != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.claimedAttributes));
        } else {
            aSN1EncodableVector.add(new DERTaggedObject(1, this.certifiedAttributes));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

