/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Target;

public class Targets
extends ASN1Encodable {
    private ASN1Sequence targets;

    private Targets(ASN1Sequence aSN1Sequence) {
        this.targets = aSN1Sequence;
    }

    public Targets(Target[] targetArray) {
        this.targets = new DERSequence(targetArray);
    }

    public static Targets getInstance(Object object) {
        if (object instanceof Targets) {
            return (Targets)object;
        }
        if (object instanceof ASN1Sequence) {
            return new Targets((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass());
    }

    public Target[] getTargets() {
        Target[] targetArray = new Target[this.targets.size()];
        int n = 0;
        Enumeration enumeration = this.targets.getObjects();
        while (enumeration.hasMoreElements()) {
            targetArray[n++] = Target.getInstance(enumeration.nextElement());
        }
        return targetArray;
    }

    public DERObject toASN1Object() {
        return this.targets;
    }
}

