/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class V2TBSCertListGenerator {
    DERInteger version = new DERInteger(1);
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate = null;
    X509Extensions extensions = null;
    private Vector crlentries = null;

    public void addCRLEntry(ASN1Sequence aSN1Sequence) {
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(aSN1Sequence);
    }

    public void addCRLEntry(DERInteger dERInteger, DERUTCTime dERUTCTime, int n) {
        this.addCRLEntry(dERInteger, new Time(dERUTCTime), n);
    }

    public void addCRLEntry(DERInteger dERInteger, Time time, int n) {
        this.addCRLEntry(dERInteger, time, n, null);
    }

    public void addCRLEntry(DERInteger dERInteger, Time time, int n, DERGeneralizedTime dERGeneralizedTime) {
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> vector2 = new Vector<X509Extension>();
        if (n != 0) {
            CRLReason cRLReason = new CRLReason(n);
            try {
                vector.addElement(X509Extensions.ReasonCode);
                vector2.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(cRLReason.getEncoded())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error encoding reason: " + iOException);
            }
        }
        if (dERGeneralizedTime != null) {
            try {
                vector.addElement(X509Extensions.InvalidityDate);
                vector2.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(dERGeneralizedTime.getEncoded())));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error encoding invalidityDate: " + iOException);
            }
        }
        if (vector.size() != 0) {
            this.addCRLEntry(dERInteger, time, new X509Extensions(vector, vector2));
        } else {
            this.addCRLEntry(dERInteger, time, null);
        }
    }

    public void addCRLEntry(DERInteger dERInteger, Time time, X509Extensions x509Extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(dERInteger);
        aSN1EncodableVector.add(time);
        if (x509Extensions != null) {
            aSN1EncodableVector.add(x509Extensions);
        }
        this.addCRLEntry(new DERSequence(aSN1EncodableVector));
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.signature);
        aSN1EncodableVector.add(this.issuer);
        aSN1EncodableVector.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            aSN1EncodableVector.add(this.nextUpdate);
        }
        if (this.crlentries != null) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            Enumeration enumeration = this.crlentries.elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector2.add((ASN1Sequence)enumeration.nextElement());
            }
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(new DERSequence(aSN1EncodableVector));
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.extensions = x509Extensions;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    public void setNextUpdate(DERUTCTime dERUTCTime) {
        this.nextUpdate = new Time(dERUTCTime);
    }

    public void setNextUpdate(Time time) {
        this.nextUpdate = time;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setThisUpdate(DERUTCTime dERUTCTime) {
        this.thisUpdate = new Time(dERUTCTime);
    }

    public void setThisUpdate(Time time) {
        this.thisUpdate = time;
    }
}

