/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class ISO9796d1Encoding
implements AsymmetricBlockCipher {
    private static byte[] shadows;
    private static byte[] inverse;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private int bitSize;
    private int padBits = 0;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 14;
        byArray[1] = 3;
        byArray[2] = 5;
        byArray[3] = 8;
        byArray[4] = 9;
        byArray[5] = 4;
        byArray[6] = 2;
        byArray[7] = 15;
        byArray[9] = 13;
        byArray[10] = 11;
        byArray[11] = 6;
        byArray[12] = 7;
        byArray[13] = 10;
        byArray[14] = 12;
        byArray[15] = 1;
        shadows = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 8;
        byArray2[1] = 15;
        byArray2[2] = 6;
        byArray2[3] = 1;
        byArray2[4] = 5;
        byArray2[5] = 2;
        byArray2[6] = 11;
        byArray2[7] = 12;
        byArray2[8] = 3;
        byArray2[9] = 4;
        byArray2[10] = 13;
        byArray2[11] = 10;
        byArray2[12] = 14;
        byArray2[13] = 9;
        byArray2[15] = 7;
        inverse = byArray2;
    }

    public ISO9796d1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
    }

    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = this.engine.processBlock(byArray, n, n2);
        int n3 = 1;
        int n4 = (this.bitSize + 13) / 16;
        if ((byArray2[byArray2.length - 1] & 0xF) != 6) {
            throw new InvalidCipherTextException("invalid forcing byte in block");
        }
        byArray2[byArray2.length - 1] = (byte)((byArray2[byArray2.length - 1] & 0xFF) >>> 4 | inverse[(byArray2[byArray2.length - 2] & 0xFF) >> 4] << 4);
        byArray2[0] = (byte)(shadows[(byArray2[1] & 0xFF) >>> 4] << 4 | shadows[byArray2[1] & 0xF]);
        boolean bl = false;
        int n5 = 0;
        int n6 = byArray2.length - 1;
        while (n6 >= byArray2.length - 2 * n4) {
            int n7 = shadows[(byArray2[n6] & 0xFF) >>> 4] << 4 | shadows[byArray2[n6] & 0xF];
            if (((byArray2[n6 - 1] ^ n7) & 0xFF) != 0) {
                if (!bl) {
                    bl = true;
                    n3 = (byArray2[n6 - 1] ^ n7) & 0xFF;
                    n5 = n6 - 1;
                } else {
                    throw new InvalidCipherTextException("invalid tsums in block");
                }
            }
            n6 -= 2;
        }
        byArray2[n5] = 0;
        byte[] byArray3 = new byte[(byArray2.length - n5) / 2];
        int n8 = 0;
        while (n8 < byArray3.length) {
            byArray3[n8] = byArray2[2 * n8 + n5 + 1];
            ++n8;
        }
        this.padBits = n3 - 1;
        return byArray3;
    }

    private byte[] encodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        int n3;
        byte[] byArray2 = new byte[(this.bitSize + 7) / 8];
        int n4 = this.padBits + 1;
        int n5 = n2;
        int n6 = (this.bitSize + 13) / 16;
        int n7 = 0;
        while (n7 < n6) {
            if (n7 > n6 - n5) {
                System.arraycopy(byArray, n + n2 - (n6 - n7), byArray2, byArray2.length - n6, n6 - n7);
            } else {
                System.arraycopy(byArray, n, byArray2, byArray2.length - (n7 + n5), n5);
            }
            n7 += n5;
        }
        int n8 = byArray2.length - 2 * n6;
        while (n8 != byArray2.length) {
            n3 = byArray2[byArray2.length - n6 + n8 / 2];
            byArray2[n8] = (byte)(shadows[(n3 & 0xFF) >>> 4] << 4 | shadows[n3 & 0xF]);
            byArray2[n8 + 1] = n3;
            n8 += 2;
        }
        int n9 = byArray2.length - 2 * n5;
        byArray2[n9] = (byte)(byArray2[n9] ^ n4);
        byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] << 4 | 6);
        n3 = 8 - (this.bitSize - 1) % 8;
        int n10 = 0;
        if (n3 != 8) {
            byArray2[0] = (byte)(byArray2[0] & 255 >>> n3);
            byArray2[0] = (byte)(byArray2[0] | 128 >>> n3);
        } else {
            byArray2[0] = 0;
            byArray2[1] = (byte)(byArray2[1] | 0x80);
            n10 = 1;
        }
        return this.engine.processBlock(byArray2, n10, byArray2.length - n10);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return (n + 1) / 2;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return (n + 1) / 2;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = null;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        }
        this.engine.init(bl, cipherParameters);
        this.bitSize = rSAKeyParameters.getModulus().bitLength();
        this.forEncryption = bl;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }

    public void setPadBits(int n) {
        if (n > 7) {
            throw new IllegalArgumentException("padBits > 7");
        }
        this.padBits = n;
    }
}

