/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;

class IntArray {
    private int[] m_ints;

    public IntArray(int n) {
        this.m_ints = new int[n];
    }

    public IntArray(BigInteger bigInteger) {
        this(bigInteger, 0);
    }

    public IntArray(BigInteger bigInteger, int n) {
        int n2;
        int n3;
        if (bigInteger.signum() == -1) {
            throw new IllegalArgumentException("Only positive Integers allowed");
        }
        if (bigInteger.equals(ECConstants.ZERO)) {
            this.m_ints = new int[1];
            return;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n4 = byArray.length;
        int n5 = 0;
        if (byArray[0] == 0) {
            --n4;
            n5 = 1;
        }
        this.m_ints = (n3 = (n4 + 3) / 4) < n ? new int[n] : new int[n3];
        int n6 = n3 - 1;
        int n7 = n4 % 4 + n5;
        int n8 = 0;
        int n9 = n5;
        if (n5 < n7) {
            while (n9 < n7) {
                n8 <<= 8;
                n2 = byArray[n9];
                if (n2 < 0) {
                    n2 += 256;
                }
                n8 |= n2;
                ++n9;
            }
            this.m_ints[n6--] = n8;
        }
        while (n6 >= 0) {
            n8 = 0;
            n2 = 0;
            while (n2 < 4) {
                int n10;
                n8 <<= 8;
                if ((n10 = byArray[n9++]) < 0) {
                    n10 += 256;
                }
                n8 |= n10;
                ++n2;
            }
            this.m_ints[n6] = n8;
            --n6;
        }
    }

    public IntArray(int[] nArray) {
        this.m_ints = nArray;
    }

    public void addShifted(IntArray intArray, int n) {
        int n2 = intArray.getUsedLength();
        int n3 = n2 + n;
        if (n3 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n3);
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 + n;
            this.m_ints[n5] = this.m_ints[n5] ^ intArray.m_ints[n4];
            ++n4;
        }
    }

    public int bitLength() {
        int n = this.getUsedLength();
        if (n == 0) {
            return 0;
        }
        int n2 = n - 1;
        int n3 = this.m_ints[n2];
        int n4 = (n2 << 5) + 1;
        if ((n3 & 0xFFFF0000) != 0) {
            if ((n3 & 0xFF000000) != 0) {
                n4 += 24;
                n3 >>>= 24;
            } else {
                n4 += 16;
                n3 >>>= 16;
            }
        } else if (n3 > 255) {
            n4 += 8;
            n3 >>>= 8;
        }
        while (n3 != 1) {
            ++n4;
            n3 >>>= 1;
        }
        return n4;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        int n = this.getUsedLength();
        if (intArray.getUsedLength() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_ints[n2] != intArray.m_ints[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void flipBit(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        int n5 = n2;
        this.m_ints[n5] = this.m_ints[n5] ^ n4;
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public int getUsedLength() {
        int n = this.m_ints.length;
        if (n < 1) {
            return 0;
        }
        if (this.m_ints[0] != 0) {
            while (this.m_ints[--n] == 0) {
            }
            return n + 1;
        }
        do {
            if (this.m_ints[--n] == 0) continue;
            return n + 1;
        } while (n > 0);
        return 0;
    }

    public int hashCode() {
        int n = this.getUsedLength();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            n2 = n2 * 31 + this.m_ints[n3];
            ++n3;
        }
        return n2;
    }

    public boolean isZero() {
        return this.m_ints.length == 0 || this.m_ints[0] == 0 && this.getUsedLength() == 0;
    }

    public IntArray multiply(IntArray intArray, int n) {
        int n2 = n + 31 >> 5;
        if (this.m_ints.length < n2) {
            this.m_ints = this.resizedInts(n2);
        }
        IntArray intArray2 = new IntArray(intArray.resizedInts(intArray.getLength() + 1));
        IntArray intArray3 = new IntArray(n + n + 31 >> 5);
        int n3 = 1;
        int n4 = 0;
        while (n4 < 32) {
            int n5 = 0;
            while (n5 < n2) {
                if ((this.m_ints[n5] & n3) != 0) {
                    intArray3.addShifted(intArray2, n5);
                }
                ++n5;
            }
            n3 <<= 1;
            intArray2.shiftLeft();
            ++n4;
        }
        return intArray3;
    }

    public void reduce(int n, int[] nArray) {
        int n2 = n + n - 2;
        while (n2 >= n) {
            if (this.testBit(n2)) {
                int n3 = n2 - n;
                this.flipBit(n3);
                this.flipBit(n2);
                int n4 = nArray.length;
                while (--n4 >= 0) {
                    this.flipBit(nArray[n4] + n3);
                }
            }
            --n2;
        }
        this.m_ints = this.resizedInts(n + 31 >> 5);
    }

    private int[] resizedInts(int n) {
        int[] nArray = new int[n];
        int n2 = this.m_ints.length;
        int n3 = n2 < n ? n2 : n;
        System.arraycopy(this.m_ints, 0, nArray, 0, n3);
        return nArray;
    }

    public void setBit(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        int n5 = n2;
        this.m_ints[n5] = this.m_ints[n5] | n4;
    }

    public void shiftLeft() {
        int n = this.getUsedLength();
        if (n == 0) {
            return;
        }
        if (this.m_ints[n - 1] < 0 && ++n > this.m_ints.length) {
            this.m_ints = this.resizedInts(this.m_ints.length + 1);
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            boolean bl2 = this.m_ints[n2] < 0;
            int n3 = n2;
            this.m_ints[n3] = this.m_ints[n3] << 1;
            if (bl) {
                int n4 = n2;
                this.m_ints[n4] = this.m_ints[n4] | 1;
            }
            bl = bl2;
            ++n2;
        }
    }

    public IntArray shiftLeft(int n) {
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return this;
        }
        if (n == 0) {
            return this;
        }
        if (n > 31) {
            throw new IllegalArgumentException("shiftLeft() for max 31 bits , " + n + "bit shift is not possible");
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 32 - n;
        nArray[0] = this.m_ints[0] << n;
        int n4 = 1;
        while (n4 < n2) {
            nArray[n4] = this.m_ints[n4] << n | this.m_ints[n4 - 1] >>> n3;
            ++n4;
        }
        nArray[n2] = this.m_ints[n2 - 1] >>> n3;
        return new IntArray(nArray);
    }

    public IntArray square(int n) {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 16;
        nArray[5] = 17;
        nArray[6] = 20;
        nArray[7] = 21;
        nArray[8] = 64;
        nArray[9] = 65;
        nArray[10] = 68;
        nArray[11] = 69;
        nArray[12] = 80;
        nArray[13] = 81;
        nArray[14] = 84;
        nArray[15] = 85;
        int[] nArray2 = nArray;
        int n2 = n + 31 >> 5;
        if (this.m_ints.length < n2) {
            this.m_ints = this.resizedInts(n2);
        }
        IntArray intArray = new IntArray(n2 + n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6 = 0;
            int n7 = 0;
            while (n7 < 4) {
                n6 >>>= 8;
                n5 = this.m_ints[n3] >>> n7 * 4 & 0xF;
                n4 = nArray2[n5] << 24;
                n6 |= n4;
                ++n7;
            }
            intArray.m_ints[n3 + n3] = n6;
            n6 = 0;
            n5 = this.m_ints[n3] >>> 16;
            n4 = 0;
            while (n4 < 4) {
                n6 >>>= 8;
                int n8 = n5 >>> n4 * 4 & 0xF;
                int n9 = nArray2[n8] << 24;
                n6 |= n9;
                ++n4;
            }
            intArray.m_ints[n3 + n3 + 1] = n6;
            ++n3;
        }
        return intArray;
    }

    public boolean testBit(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        return (this.m_ints[n2] & n4) != 0;
    }

    public BigInteger toBigInteger() {
        int n;
        int n2 = this.getUsedLength();
        if (n2 == 0) {
            return ECConstants.ZERO;
        }
        int n3 = this.m_ints[n2 - 1];
        byte[] byArray = new byte[4];
        int n4 = 0;
        boolean bl = false;
        int n5 = 3;
        while (n5 >= 0) {
            n = n3 >>> 8 * n5;
            if (bl || n != 0) {
                bl = true;
                byArray[n4++] = n;
            }
            --n5;
        }
        n = 4 * (n2 - 1) + n4;
        byte[] byArray2 = new byte[n];
        int n6 = 0;
        while (n6 < n4) {
            byArray2[n6] = byArray[n6];
            ++n6;
        }
        int n7 = n2 - 2;
        while (n7 >= 0) {
            int n8 = 3;
            while (n8 >= 0) {
                byArray2[n4++] = (byte)(this.m_ints[n7] >>> 8 * n8);
                --n8;
            }
            --n7;
        }
        return new BigInteger(1, byArray2);
    }

    public String toString() {
        int n = this.getUsedLength();
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.m_ints[n - 1]));
        int n2 = n - 2;
        while (n2 >= 0) {
            String string = Integer.toBinaryString(this.m_ints[n2]);
            int n3 = string.length();
            while (n3 < 8) {
                string = "0" + string;
                ++n3;
            }
            stringBuffer.append(string);
            --n2;
        }
        return stringBuffer.toString();
    }
}

