/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.misc;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class CAST5CBCParameters
implements DEREncodable {
    DERInteger keyLength;
    DEROctetString iv;

    public static CAST5CBCParameters getInstance(Object object) {
        if (object instanceof CAST5CBCParameters) {
            return (CAST5CBCParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CAST5CBCParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in CAST5CBCParameter factory");
    }

    public CAST5CBCParameters(byte[] byArray, int n) {
        this.iv = new DEROctetString(byArray);
        this.keyLength = new DERInteger(n);
    }

    public CAST5CBCParameters(ASN1Sequence aSN1Sequence) {
        this.iv = (DEROctetString)aSN1Sequence.getObjectAt(0);
        this.keyLength = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public int getKeyLength() {
        return this.keyLength.getValue().intValue();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.iv);
        dERConstructedSequence.addObject(this.keyLength);
        return dERConstructedSequence;
    }
}

