/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class ResponseBytes
implements DEREncodable {
    DERObjectIdentifier responseType;
    ASN1OctetString response;

    public ResponseBytes(ASN1Sequence aSN1Sequence) {
        this.responseType = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.response = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
    }

    public static ResponseBytes getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponseBytes.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ResponseBytes getInstance(Object object) {
        if (object == null || object instanceof ResponseBytes) {
            return (ResponseBytes)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ResponseBytes((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObjectIdentifier getResponseType() {
        return this.responseType;
    }

    public ASN1OctetString getResponse() {
        return this.response;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add(this.responseType);
        dEREncodableVector.add(this.response);
        return new DERSequence(dEREncodableVector);
    }
}

