/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DigestInfo;

public class MacData
implements DEREncodable {
    DigestInfo digInfo;
    byte[] salt;
    BigInteger iterationCount;

    public static MacData getInstance(Object object) {
        if (object instanceof MacData) {
            return (MacData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new MacData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public MacData(ASN1Sequence aSN1Sequence) {
        this.digInfo = DigestInfo.getInstance(aSN1Sequence.getObjectAt(0));
        this.salt = ((DEROctetString)aSN1Sequence.getObjectAt(1)).getOctets();
        this.iterationCount = aSN1Sequence.size() == 3 ? ((DERInteger)aSN1Sequence.getObjectAt(2)).getValue() : BigInteger.valueOf(1L);
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n) {
        this.digInfo = digestInfo;
        this.salt = byArray;
        this.iterationCount = BigInteger.valueOf(n);
    }

    public DigestInfo getMac() {
        return this.digInfo;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public BigInteger getIterationCount() {
        return this.iterationCount;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add(this.digInfo);
        dEREncodableVector.add(new DEROctetString(this.salt));
        dEREncodableVector.add(new DERInteger(this.iterationCount));
        return new DERSequence(dEREncodableVector);
    }
}

