/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBES2Algorithms
extends AlgorithmIdentifier
implements PKCSObjectIdentifiers {
    private DERObjectIdentifier objectId;
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Algorithms(DERConstructedSequence dERConstructedSequence) {
        super(dERConstructedSequence);
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.objectId = (DERObjectIdentifier)enumeration.nextElement();
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)enumeration.nextElement();
        enumeration = dERConstructedSequence2.getObjects();
        DERConstructedSequence dERConstructedSequence3 = (DERConstructedSequence)enumeration.nextElement();
        this.func = dERConstructedSequence3.getObjectAt(0).equals(PKCSObjectIdentifiers.id_PBKDF2) ? new PBKDF2Params(dERConstructedSequence3) : new KeyDerivationFunc(dERConstructedSequence3);
        this.scheme = new EncryptionScheme((DERConstructedSequence)enumeration.nextElement());
    }

    public DERObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.objectId);
        dERConstructedSequence2.addObject(this.func);
        dERConstructedSequence2.addObject(this.scheme);
        dERConstructedSequence.addObject(dERConstructedSequence2);
        return dERConstructedSequence;
    }
}

