/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.esf.CommitmentTypeIdentifier;
import org.bouncycastle.asn1.esf.CommitmentTypeQualifier;
import org.bouncycastle.util.test.SimpleTest;

public class CommitmentTypeQualifierUnitTest
extends SimpleTest {
    public String getName() {
        return "CommitmentTypeQualifier";
    }

    public void performTest() throws Exception {
        CommitmentTypeQualifier commitmentTypeQualifier = new CommitmentTypeQualifier(CommitmentTypeIdentifier.proofOfOrigin);
        this.checkConstruction(commitmentTypeQualifier, CommitmentTypeIdentifier.proofOfOrigin, null);
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.2");
        commitmentTypeQualifier = new CommitmentTypeQualifier(CommitmentTypeIdentifier.proofOfOrigin, dERObjectIdentifier);
        this.checkConstruction(commitmentTypeQualifier, CommitmentTypeIdentifier.proofOfOrigin, dERObjectIdentifier);
        commitmentTypeQualifier = CommitmentTypeQualifier.getInstance(null);
        if (commitmentTypeQualifier != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CommitmentTypeQualifier.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CommitmentTypeQualifier commitmentTypeQualifier, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this.checkStatement(commitmentTypeQualifier, dERObjectIdentifier, aSN1Encodable);
        commitmentTypeQualifier = CommitmentTypeQualifier.getInstance(commitmentTypeQualifier);
        this.checkStatement(commitmentTypeQualifier, dERObjectIdentifier, aSN1Encodable);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(commitmentTypeQualifier.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        commitmentTypeQualifier = CommitmentTypeQualifier.getInstance(aSN1Sequence);
        this.checkStatement(commitmentTypeQualifier, dERObjectIdentifier, aSN1Encodable);
    }

    private void checkStatement(CommitmentTypeQualifier commitmentTypeQualifier, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) {
        if (!commitmentTypeQualifier.getCommitmentTypeIdentifier().equals(dERObjectIdentifier)) {
            this.fail("commitmentTypeIds don't match.");
        }
        if (aSN1Encodable != null) {
            if (!commitmentTypeQualifier.getQualifier().equals(aSN1Encodable)) {
                this.fail("qualifiers don't match.");
            }
        } else if (commitmentTypeQualifier.getQualifier() != null) {
            this.fail("qualifier found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        CommitmentTypeQualifierUnitTest.runTest(new CommitmentTypeQualifierUnitTest());
    }
}

