/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode("0603813403");
    byte[] req2 = Hex.decode("06082A36FFFFFFDD6311");

    public String getName() {
        return "OID";
    }

    private void recodeCheck(String string, byte[] byArray) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)aSN1InputStream.readObject();
        if (!dERObjectIdentifier.equals(dERObjectIdentifier2)) {
            this.fail("oid ID didn't match", dERObjectIdentifier, dERObjectIdentifier2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERObjectIdentifier);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length != byArray.length) {
            this.fail("failed length test");
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            this.fail("failed comparison test", new String(Hex.encode(byArray)), new String(Hex.encode(byArray2)));
        }
    }

    private void valueCheck(String string) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObjectIdentifier);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        dERObjectIdentifier = (DERObjectIdentifier)aSN1InputStream.readObject();
        if (!dERObjectIdentifier.getId().equals(string)) {
            this.fail("failed oid check for " + string);
        }
    }

    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.valueCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.valueCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.valueCheck("1.2.123.12345678901.1.1.1");
        this.valueCheck("2.25.196556539987194312349856245628873852187.1");
    }

    public static void main(String[] stringArray) {
        OIDTest.runTest(new OIDTest());
    }
}

