/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST28147Test
extends CipherTest {
    static String input1 = "0000000000000000";
    static String output1 = "1b0bbc32cebcab42";
    static String input2 = "bc350e71aac5f5c2";
    static String output2 = "d35ab653493b49f5";
    static String input3 = "bc350e71aa11345709acde";
    static String output3 = "8824c124c4fd14301fb1e8";
    static String input4 = "000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f";
    static String output4 = "29b7083e0a6d955ca0ec5b04fdb4ea41949f1dd2efdf17baffc1780b031f3934";
    static byte[] TestSBox = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(1, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(2, new CBCBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF")), Hex.decode("1234567890abcdef")), input2, output2), new BlockCipherVectorTest(3, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("0011223344556677889900112233445566778899001122334455667788990011")), Hex.decode("1234567890abcdef")), input3, output3), new BlockCipherVectorTest(4, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new KeyParameter(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5")), Hex.decode("aafd12f659cae634")), input4, output4), new BlockCipherVectorTest(5, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(6, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "b587f7a0814c911d"), new BlockCipherVectorTest(7, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "e8287f53f991d52b"), new BlockCipherVectorTest(8, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "c41009dba22ebe35"), new BlockCipherVectorTest(9, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-B")), Hex.decode("1234567890abcdef")), "0000000000000000", "80d8723fcd3aba28"), new BlockCipherVectorTest(10, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-C")), Hex.decode("1234567890abcdef")), "0000000000000000", "739f6f95068499b5"), new BlockCipherVectorTest(11, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-D")), Hex.decode("1234567890abcdef")), "0000000000000000", "4663f720f4340f57"), new BlockCipherVectorTest(12, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "5bb0a31d218ed564"), new BlockCipherVectorTest(13, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), TestSBox), Hex.decode("1234567890abcdef")), "0000000000000000", "c3af96ef788667c5"), new BlockCipherVectorTest(14, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("4ef72b778f0b0bebeef4f077551cb74a927b470ad7d7f2513454569a247e989d")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "bc350e71aa11345709acde", "1bcc2282707c676fb656dc")};
    private static final int GOST28147_KEY_LENGTH = 32;

    private byte[] generateKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        GOST3411Digest gOST3411Digest = new GOST3411Digest();
        gOST3411Digest.update(byArray, 0, byArray.length);
        gOST3411Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    GOST28147Test() {
        super(tests);
    }

    public void performTest() throws Exception {
        int n;
        super.performTest();
        byte[] byArray = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
        byte[] byArray2 = Hex.decode("8ad3c8f56b27ff1fbd46409359bdc796bc350e71aac5f5c0");
        byte[] byArray3 = new byte[byArray.length];
        byte[] byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        CipherParameters cipherParameters = new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A"));
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new GOST28147Engine());
        bufferedBlockCipher.init(true, cipherParameters);
        int n2 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n2);
        }
        catch (CryptoException cryptoException) {
            this.fail("failed - exception " + cryptoException.toString(), cryptoException);
        }
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        for (int i = 0; i != byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        byArray = Hex.decode("bc350e71aac5f5c2");
        byArray2 = Hex.decode("0ebbbafcf38f14a5");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, cipherParameters);
        n2 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n2);
        }
        catch (CryptoException cryptoException) {
            this.fail("failed - exception " + cryptoException.toString(), cryptoException);
        }
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        for (n = 0; n != byArray3.length; ++n) {
            if (byArray3[n] == byArray2[n]) continue;
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        byArray = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byArray2 = Hex.decode("64988982819f0a1655e226e19ecad79d10cc73bac95c5d7da034786c12294225");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("aafd12f659cae634"));
        bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, cipherParameters);
        n2 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        bufferedBlockCipher.doFinal(byArray3, n2);
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        for (n = 0; n != byArray3.length; ++n) {
            if (byArray3[n] == byArray2[n]) continue;
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        byArray = Hex.decode("bc350e71aa11345709acde");
        byArray2 = Hex.decode("1bcc2282707c676fb656dc");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher(new GOFBBlockCipher(new GOST28147Engine()));
        bufferedBlockCipher.init(true, cipherParameters);
        n2 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        bufferedBlockCipher.doFinal(byArray3, n2);
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        for (n = 0; n != byArray3.length; ++n) {
            if (byArray3[n] == byArray2[n]) continue;
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
    }

    public String getName() {
        return "GOST28147";
    }

    public static void main(String[] stringArray) {
        GOST28147Test.runTest(new GOST28147Test());
    }
}

