/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.TBCPadding;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PaddingTest
extends SimpleTest {
    private void blockCheck(PaddedBufferedBlockCipher paddedBufferedBlockCipher, BlockCipherPadding blockCipherPadding, KeyParameter keyParameter, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        byte[] byArray3 = new byte[byArray.length];
        try {
            paddedBufferedBlockCipher.init(true, keyParameter);
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray2, n);
            paddedBufferedBlockCipher.init(false, keyParameter);
            int n2 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n, byArray3, 0);
            n2 += paddedBufferedBlockCipher.doFinal(byArray3, n2);
            if (!this.areEqual(byArray, byArray3)) {
                this.fail("failed to decrypt - i = " + byArray.length + ", padding = " + blockCipherPadding.getPaddingName());
            }
        }
        catch (Exception exception) {
            this.fail("Exception - " + exception.toString(), exception);
        }
    }

    public void testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] byArray3 = new byte[]{-1, -1, -1, 0, 0, 0, 0, 0};
        if (byArray != null) {
            blockCipherPadding.addPadding(byArray3, 3);
            if (!this.areEqual(byArray3, byArray)) {
                this.fail("failed ff test for " + blockCipherPadding.getPaddingName());
            }
        }
        if (byArray2 != null) {
            byArray3 = new byte[8];
            blockCipherPadding.addPadding(byArray3, 4);
            if (!this.areEqual(byArray3, byArray2)) {
                this.fail("failed zero test for " + blockCipherPadding.getPaddingName());
            }
        }
        for (int i = 1; i != 200; ++i) {
            byArray3 = new byte[i];
            secureRandom.nextBytes(byArray3);
            this.blockCheck(paddedBufferedBlockCipher, blockCipherPadding, keyParameter, byArray3);
        }
    }

    public void performTest() {
        SecureRandom secureRandom = new SecureRandom(new byte[20]);
        secureRandom.setSeed(System.currentTimeMillis());
        this.testPadding(new PKCS7Padding(), secureRandom, Hex.decode("ffffff0505050505"), Hex.decode("0000000004040404"));
        this.testPadding(new ISO10126d2Padding(), secureRandom, null, null);
        this.testPadding(new X923Padding(), secureRandom, null, null);
        this.testPadding(new TBCPadding(), secureRandom, Hex.decode("ffffff0000000000"), Hex.decode("00000000ffffffff"));
        this.testPadding(new ZeroBytePadding(), secureRandom, Hex.decode("ffffff0000000000"), null);
        this.testPadding(new ISO7816d4Padding(), secureRandom, Hex.decode("ffffff8000000000"), Hex.decode("0000000080000000"));
    }

    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] stringArray) {
        PaddingTest.runTest(new PaddingTest());
    }
}

