/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RIPEMD128HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"fbf61f9492aa4bbf81c172e84e0734db", "875f828862b6b334b427c55f9f7ff09b", "09f0b2846d2f543da363cbec8d62a38d", "bdbbd7cf03e44b5aa60af815be4d2294", "e79808f24b25fd031c155f0d551d9a3a", "dc732928de98104a1f59d373c150acbb", "5c6bec96793e16d40690c237635f30c5"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"};

    public String getName() {
        return "RIPEMD128HMac";
    }

    public TestResult perform() {
        HMac hMac = new HMac(new RIPEMD128Digest());
        byte[] byArray = new byte[hMac.getMacSize()];
        for (int i = 0; i < messages.length; ++i) {
            byte[] byArray2 = messages[i].getBytes();
            if (messages[i].startsWith("0x")) {
                byArray2 = Hex.decode(messages[i].substring(2));
            }
            hMac.init(new KeyParameter(Hex.decode(keys[i])));
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray, 0);
            if (Arrays.areEqual(byArray, Hex.decode(digests[i]))) continue;
            return new SimpleTestResult(false, this.getName() + ": Vector " + i + " failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        RIPEMD128HMacTest rIPEMD128HMacTest = new RIPEMD128HMacTest();
        TestResult testResult = rIPEMD128HMacTest.perform();
        System.out.println(testResult);
    }
}

