/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.pgv;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.envoyproxy.pgv.ValidationException;

public final class TimestampValidation {
    private TimestampValidation() {
    }

    public static void within(String field, Timestamp value, Duration duration, Timestamp when) throws ValidationException {
        Duration between = Timestamps.between((Timestamp)when, (Timestamp)value);
        if (Long.compare(Math.abs(Durations.toNanos((Duration)between)), Math.abs(Durations.toNanos((Duration)duration))) == 1) {
            throw new ValidationException(field, value, "value must be within " + Durations.toString((Duration)duration) + " of " + Timestamps.toString((Timestamp)when));
        }
    }

    public static Timestamp toTimestamp(long seconds, int nanos) {
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    public static Duration toDuration(long seconds, long nanos) {
        return Duration.newBuilder().setSeconds(seconds).setNanos((int)nanos).build();
    }

    public static Timestamp currentTimestamp() {
        return Timestamps.fromMillis((long)System.currentTimeMillis());
    }
}

