/*
 * Decompiled with CFR 0.152.
 */
package ca.szc.maven.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="set-properties", defaultPhase=LifecyclePhase.INITIALIZE)
public class SetPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="jsonpath.file", required=true)
    private String file;
    @Parameter(required=true)
    private Map<String, String> properties;

    public void execute() throws MojoExecutionException {
        Object json;
        FileSystem fs = FileSystems.getDefault();
        Path inputJson = fs.getPath(this.file, new String[0]);
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        try (InputStream in = Files.newInputStream(inputJson, new OpenOption[0]);){
            json = conf.jsonProvider().parse(in, "UTF-8");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to read input json file");
            throw new MojoExecutionException("Unable to read file '" + this.file + "'", (Exception)e);
        }
        DocumentContext context = JsonPath.parse((Object)json, (Configuration)conf);
        int count = 0;
        Properties sessionProperties = this.session.getUserProperties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String propertyName = entry.getKey();
            String propertyJsonPath = entry.getValue();
            this.getLog().debug((CharSequence)("Reading value for " + propertyName + " with JsonPath expression " + propertyJsonPath));
            List propertyValues = (List)context.read(propertyJsonPath, new Predicate[0]);
            if (propertyValues.size() != 1) {
                this.getLog().error((CharSequence)("More than 1 value found for indefinite JsonPath expression: " + propertyJsonPath));
                throw new MojoExecutionException("More than 1 value found for indefinite JsonPath expression: " + propertyJsonPath);
            }
            String propertyValue = (String)propertyValues.get(0);
            sessionProperties.setProperty(propertyName, propertyValue);
            this.getLog().info((CharSequence)(propertyName + "=" + propertyValue));
            ++count;
        }
        if (count == 0) {
            this.getLog().error((CharSequence)(count + " build properties set from json file " + this.file));
            throw new MojoExecutionException("No properties were defined for setting");
        }
        this.getLog().info((CharSequence)(count + " build properties set from json file " + this.file));
    }
}

