/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.primitive;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.DataTypeUtil;
import ca.uhn.hl7v2.model.primitive.CommonDT;
import ca.uhn.hl7v2.model.primitive.CommonTM;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CommonTS
implements Serializable {
    private CommonDT dt;
    private CommonTM tm;

    public CommonTS() {
    }

    public CommonTS(String val) throws DataTypeException {
        this.setValue(val);
    }

    public int getDay() {
        int day = 0;
        if (this.dt != null) {
            day = this.dt.getDay();
        }
        return day;
    }

    public float getFractSecond() {
        float fractionOfSec = 0.0f;
        if (this.tm != null) {
            fractionOfSec = this.tm.getFractSecond();
        }
        return fractionOfSec;
    }

    public int getGMTOffset() {
        int offSet = 0;
        if (this.tm != null) {
            offSet = this.tm.getGMTOffset();
        }
        return offSet;
    }

    public int getHour() {
        int hour = 0;
        if (this.tm != null) {
            hour = this.tm.getHour();
        }
        return hour;
    }

    public int getMinute() {
        int minute = 0;
        if (this.tm != null) {
            minute = this.tm.getMinute();
        }
        return minute;
    }

    public int getMonth() {
        int month = 0;
        if (this.dt != null) {
            month = this.dt.getMonth();
        }
        return month;
    }

    public int getSecond() {
        int seconds = 0;
        if (this.tm != null) {
            seconds = this.tm.getSecond();
        }
        return seconds;
    }

    public String getValue() {
        String value = null;
        if (this.dt != null) {
            value = this.dt.getValue();
        }
        if (this.tm != null && value != null && !value.equals("")) {
            if (this.tm.getValue() != null && !this.tm.getValue().equals("")) {
                value = this.tm.getValue().equals("\"\"") && this.dt.getValue().equals("\"\"") ? "\"\"" : value + this.tm.getValue();
            }
            if (this.tm.getValue() == null || this.tm.getValue().equals("")) {
                int offset = this.tm.getGMTOffset();
                String offsetStr = "";
                if (offset != -99) {
                    offsetStr = DataTypeUtil.preAppendZeroes(Math.abs(offset), 4);
                    offsetStr = this.tm.getGMTOffset() >= 0 ? "+" + offsetStr : "-" + offsetStr;
                }
                value = value + offsetStr;
            }
        }
        return value;
    }

    public Calendar getValueAsCalendar() {
        if (this.getValue() == null) {
            return null;
        }
        Calendar retVal = this.tm.getValueAsCalendar();
        retVal.set(1, this.getYear());
        retVal.set(2, this.getMonth() - 1);
        retVal.set(5, this.getDay());
        return retVal;
    }

    public Date getValueAsDate() {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValueAsCalendar().getTime();
    }

    public int getYear() {
        int year = 0;
        if (this.dt != null) {
            year = this.dt.getYear();
        }
        return year;
    }

    public void setDateMinutePrecision(int yr, int mnth, int dy, int hr, int min) throws DataTypeException {
        try {
            this.setDatePrecision(yr, mnth, dy);
            if (this.tm == null) {
                this.tm = new CommonTM();
            }
            this.tm.setHourMinutePrecision(hr, min);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setDatePrecision(int yr, int mnth, int dy) throws DataTypeException {
        try {
            if (this.dt == null) {
                this.dt = new CommonDT();
            }
            this.dt.setYearMonthDayPrecision(yr, mnth, dy);
            this.tm = null;
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setDateSecondPrecision(int yr, int mnth, int dy, int hr, int min, float sec) throws DataTypeException {
        try {
            this.setDatePrecision(yr, mnth, dy);
            if (this.tm == null) {
                this.tm = new CommonTM();
            }
            this.tm.setHourMinSecondPrecision(hr, min, sec);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setOffset(int signedOffset) throws DataTypeException {
        try {
            if (this.tm == null) {
                this.tm = new CommonTM();
            }
            this.tm.setOffset(signedOffset);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setValue(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int yr = theCalendar.get(1);
        int mnth = theCalendar.get(2) + 1;
        int dy = theCalendar.get(5);
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        float sec = (float)theCalendar.get(13) + (float)theCalendar.get(14) / 1000.0f;
        this.setDateSecondPrecision(yr, mnth, dy, hr, min, sec);
        int timeZoneOffset = theCalendar.get(15);
        int hourOffset = timeZoneOffset / 3600000;
        int minuteOffset = timeZoneOffset / 60000 % 60;
        int zoneOffset = hourOffset * 100 + minuteOffset;
        this.setOffset(zoneOffset);
    }

    public void setValue(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(theDate);
        this.setValue(cal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String val) throws DataTypeException {
        if (val != null && !val.equals("") && !val.equals("\"\"")) {
            try {
                if (val.length() < 4) {
                    String msg = "The length of the TS datatype value must be at least 4 characters in length.";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                if (val.length() > 24) {
                    String msg = "The length of the TS datatype value must not be more than 24 characters in length.";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                String dateVal = null;
                String timeVal = null;
                String timeValLessOffset = null;
                int sp = val.indexOf("+");
                int sm = val.indexOf("-");
                int indexOfSign = -1;
                boolean offsetExists = false;
                boolean timeValIsOffsetOnly = false;
                if (sp != -1 || sm != -1) {
                    offsetExists = true;
                }
                if (sp != -1) {
                    indexOfSign = sp;
                }
                if (sm != -1) {
                    indexOfSign = sm;
                }
                if (!offsetExists) {
                    if (val.length() <= 8) {
                        dateVal = val;
                    } else {
                        dateVal = val.substring(0, 8);
                        timeValLessOffset = timeVal = val.substring(8);
                    }
                }
                if (offsetExists) {
                    if (indexOfSign > 8) {
                        dateVal = val.substring(0, 8);
                        timeVal = val.substring(8);
                        timeValLessOffset = val.substring(8, indexOfSign);
                    } else {
                        dateVal = val.substring(0, indexOfSign);
                        timeVal = val.substring(indexOfSign);
                        timeValIsOffsetOnly = true;
                    }
                }
                this.dt = new CommonDT();
                this.dt.setValue(dateVal);
                if (timeVal == null && !offsetExists) {
                    this.tm = new CommonTM();
                    this.tm.setValue("");
                }
                if (timeVal != null && !timeValIsOffsetOnly) {
                    if (timeValLessOffset.length() < 2) {
                        String msg = "The length of the time component for the TM datatype value does not conform to the allowable format YYYY[MM[DD[HH[MM[SS[.S[S[S[S]]]]]]]]][+/-ZZZZ].";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.tm = new CommonTM();
                    this.tm.setValue(timeVal);
                }
                if (timeVal == null || !timeValIsOffsetOnly) return;
                if (timeVal.length() != 5) {
                    String msg = "The length of the GMT offset for the TM datatype value does not conform to the allowable format [+/-ZZZZ]";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                this.tm = new CommonTM();
                if (timeVal.indexOf("+") == 0) {
                    timeVal = timeVal.substring(1);
                }
                int signedOffset = Integer.parseInt(timeVal);
                this.tm.setOffset(signedOffset);
                return;
            }
            catch (DataTypeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataTypeException(e);
            }
        } else {
            if (val == null) {
                this.dt = null;
                this.tm = null;
            }
            if (val != null && val.equals("")) {
                this.dt = new CommonDT();
                this.dt.setValue("");
                this.tm = new CommonTM();
                this.tm.setValue("");
            }
            if (val == null || !val.equals("\"\"")) return;
            this.dt = new CommonDT();
            this.dt.setValue("\"\"");
            this.tm = new CommonTM();
            this.tm.setValue("\"\"");
        }
    }

    public void setValueToMinute(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int yr = theCalendar.get(1);
        int mnth = theCalendar.get(2) + 1;
        int dy = theCalendar.get(5);
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        this.setDateMinutePrecision(yr, mnth, dy, hr, min);
    }

    public void setValueToMinute(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        this.setValueToMinute(calendar);
    }

    public void setValueToSecond(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int yr = theCalendar.get(1);
        int mnth = theCalendar.get(2) + 1;
        int dy = theCalendar.get(5);
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        int sec = theCalendar.get(13);
        this.setDateSecondPrecision(yr, mnth, dy, hr, min, sec);
    }

    public void setValueToSecond(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        this.setValueToSecond(calendar);
    }

    public static String toHl7TSFormat(GregorianCalendar cal) throws DataTypeException {
        String val = "";
        try {
            cal.setLenient(false);
            int calYear = cal.get(1);
            int calMonth = cal.get(2) + 1;
            int calDay = cal.get(5);
            int calHour = cal.get(11);
            int calMin = cal.get(12);
            int calSec = cal.get(13);
            int calMilli = cal.get(14);
            float fractSec = (float)calMilli / 1000.0f;
            float calSecFloat = (float)calSec + fractSec;
            int calOffset = cal.get(15) + cal.get(16);
            int offSetSignInt = calOffset < 0 ? -1 : 1;
            int absGmtOffSet = Math.abs(calOffset);
            int gmtOffSetHours = absGmtOffSet / 3600000;
            int gmtOffSetMin = absGmtOffSet / 60000 % 60;
            calOffset = (gmtOffSetHours * 100 + gmtOffSetMin) * offSetSignInt;
            CommonTS ts = new CommonTS();
            ts.setDateSecondPrecision(calYear, calMonth, calDay, calHour, calMin, calSecFloat);
            ts.setOffset(calOffset);
            val = ts.getValue();
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
        return val;
    }

    public static void main(String[] args) throws DataTypeException {
        CommonTS ts = new CommonTS();
        ts.setValue("1984");
        System.out.println(ts.getValue());
    }
}

