/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractSuperMessage;
import ca.uhn.hl7v2.model.DoNotCacheStructure;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.SuperStructure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingDetector;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Escape;
import ca.uhn.hl7v2.parser.IStructureDefinition;
import ca.uhn.hl7v2.parser.MessageIterator;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.OldPipeParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.StructureDefinition;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeParser
extends Parser {
    private static final Logger log = LoggerFactory.getLogger(PipeParser.class);
    static final String SEGMENT_DELIMITER = "\r";
    private final HashMap<Class<? extends Message>, HashMap<String, StructureDefinition>> myStructureDefinitions = new HashMap();
    public static final String DEFAULT_LEGACY_MODE_PROPERTY = "ca.uhn.hl7v2.parser.PipeParser.default_legacy_mode";
    private Boolean myLegacyMode = null;

    public PipeParser() {
    }

    public PipeParser(HapiContext context) {
        super(context);
    }

    public PipeParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    @Override
    public String getEncoding(String message) {
        return EncodingDetector.isEr7Encoded(message) ? this.getDefaultEncoding() : null;
    }

    @Override
    public String getDefaultEncoding() {
        return "VB";
    }

    public String getMessageStructure(String message) throws HL7Exception {
        return this.getStructure((String)message).messageStructure;
    }

    private MessageStructure getStructure(String message) throws HL7Exception {
        String messageStructure;
        boolean explicityDefined;
        block6: {
            EncodingCharacters ec = PipeParser.getEncodingChars(message);
            explicityDefined = true;
            try {
                String[] fields = PipeParser.split(message.substring(0, Math.max(message.indexOf(SEGMENT_DELIMITER), message.length())), String.valueOf(ec.getFieldSeparator()));
                String wholeFieldNine = fields[8];
                String[] comps = PipeParser.split(wholeFieldNine, String.valueOf(ec.getComponentSeparator()));
                if (comps.length >= 3) {
                    messageStructure = comps[2];
                    break block6;
                }
                if (comps.length > 0 && comps[0] != null && comps[0].equals("ACK")) {
                    messageStructure = "ACK";
                    break block6;
                }
                if (comps.length == 2) {
                    explicityDefined = false;
                    messageStructure = comps[0] + "_" + comps[1];
                    break block6;
                }
                StringBuilder buf = new StringBuilder("Can't determine message structure from MSH-9: ");
                buf.append(wholeFieldNine);
                if (comps.length < 3) {
                    buf.append(" HINT: there are only ");
                    buf.append(comps.length);
                    buf.append(" of 3 components present");
                }
                throw new HL7Exception(buf.toString(), ErrorCode.UNSUPPORTED_MESSAGE_TYPE);
            }
            catch (IndexOutOfBoundsException e) {
                throw new HL7Exception("Can't find message structure (MSH-9-3): " + e.getMessage(), ErrorCode.UNSUPPORTED_MESSAGE_TYPE);
            }
        }
        return new MessageStructure(messageStructure, explicityDefined);
    }

    private static EncodingCharacters getEncodingChars(String message) throws HL7Exception {
        if (message.length() < 8) {
            throw new HL7Exception("Invalid message content: \"" + message + "\"");
        }
        return new EncodingCharacters(message.charAt(3), message.substring(4, 8));
    }

    @Override
    protected Message doParse(String message, String version) throws HL7Exception {
        MessageStructure structure = this.getStructure(message);
        Message m = this.instantiateMessage(structure.messageStructure, version, structure.explicitlyDefined);
        m.setValidationContext(this.getValidationContext());
        m.setParser(this);
        this.parse(m, message);
        return m;
    }

    @Override
    protected Message doParseForSpecificPackage(String message, String version, String packageName) throws HL7Exception {
        MessageStructure structure = this.getStructure(message);
        Message m = this.instantiateMessageInASpecificPackage(structure.messageStructure, version, structure.explicitlyDefined, packageName);
        this.parse(m, message);
        return m;
    }

    private IStructureDefinition getStructureDefinition(Message theMessage) throws HL7Exception {
        Set<String> appliesTo;
        StructureDefinition retVal;
        Class<?> clazz = theMessage.getClass();
        HashMap<String, StructureDefinition> definitions = this.myStructureDefinitions.get(clazz);
        if (definitions != null && (retVal = definitions.get(theMessage.getName())) != null) {
            return retVal;
        }
        if (theMessage instanceof SuperStructure && !(appliesTo = ((SuperStructure)((Object)theMessage)).getStructuresWhichChildAppliesTo("MSH")).contains(theMessage.getName())) {
            throw new HL7Exception("Superstructure " + theMessage.getClass().getSimpleName() + " does not apply to message " + theMessage.getName() + ", can not parse.");
        }
        if (clazz.isAnnotationPresent(DoNotCacheStructure.class)) {
            Holder<StructureDefinition> previousLeaf = new Holder<StructureDefinition>();
            retVal = this.createStructureDefinition(theMessage, previousLeaf, theMessage.getName());
        } else {
            Message message = (Message)ReflectionUtil.instantiateMessage(clazz, this.getFactory());
            Holder<StructureDefinition> previousLeaf = new Holder<StructureDefinition>();
            retVal = this.createStructureDefinition(message, previousLeaf, theMessage.getName());
            if (!this.myStructureDefinitions.containsKey(clazz)) {
                this.myStructureDefinitions.put(clazz, new HashMap());
            }
            this.myStructureDefinitions.get(clazz).put(theMessage.getName(), retVal);
        }
        return retVal;
    }

    private StructureDefinition createStructureDefinition(Structure theStructure, Holder<StructureDefinition> thePreviousLeaf, String theStructureName) throws HL7Exception {
        StructureDefinition retVal = new StructureDefinition();
        retVal.setName(theStructure.getName());
        if (theStructure instanceof Group) {
            retVal.setSegment(false);
            Group group = (Group)theStructure;
            int index = 0;
            List<String> childNames = Arrays.asList(group.getNames());
            if (theStructure instanceof SuperStructure) {
                String struct = theStructureName;
                Map<String, String> evtMap = new DefaultModelClassFactory().getEventMapForVersion(Version.versionOf(theStructure.getMessage().getVersion()));
                if (evtMap.containsKey(struct)) {
                    struct = evtMap.get(struct);
                }
                childNames = ((SuperStructure)theStructure).getChildNamesForStructure(struct);
            }
            for (String nextName : childNames) {
                Structure nextChild = group.get(nextName);
                StructureDefinition structureDefinition = this.createStructureDefinition(nextChild, thePreviousLeaf, theStructureName);
                structureDefinition.setNameAsItAppearsInParent(nextName);
                structureDefinition.setRepeating(group.isRepeating(nextName));
                structureDefinition.setRequired(group.isRequired(nextName));
                structureDefinition.setChoiceElement(group.isChoiceElement(nextName));
                structureDefinition.setPosition(index++);
                structureDefinition.setParent(retVal);
                retVal.addChild(structureDefinition);
            }
        } else {
            if (thePreviousLeaf.getObject() != null) {
                thePreviousLeaf.getObject().setNextLeaf(retVal);
            }
            thePreviousLeaf.setObject(retVal);
            retVal.setSegment(true);
        }
        return retVal;
    }

    @Override
    public void parse(Segment destination, String segment, EncodingCharacters encodingChars) throws HL7Exception {
        this.parse(destination, segment, encodingChars, 0);
    }

    public void parse(Segment destination, String segment, EncodingCharacters encodingChars, int theRepetition) throws HL7Exception {
        int fieldOffset = 0;
        if (PipeParser.isDelimDefSegment(destination.getName())) {
            fieldOffset = 1;
            Terser.set(destination, 1, 0, 1, 1, String.valueOf(encodingChars.getFieldSeparator()));
        }
        String[] fields = PipeParser.split(segment, String.valueOf(encodingChars.getFieldSeparator()));
        for (int i = 1; i < fields.length; ++i) {
            boolean isMSH2;
            String[] reps = PipeParser.split(fields[i], String.valueOf(encodingChars.getRepetitionSeparator()));
            boolean bl = isMSH2 = PipeParser.isDelimDefSegment(destination.getName()) && i + fieldOffset == 2;
            if (isMSH2) {
                reps = new String[]{fields[i]};
            }
            for (int j = 0; j < reps.length; ++j) {
                try {
                    log.trace("Parsing field {} repetition {}", (Object)(i + fieldOffset), (Object)j);
                    Type field = destination.getField(i + fieldOffset, j);
                    if (isMSH2) {
                        Terser.getPrimitive(field, 1, 1).setValue(reps[j]);
                        continue;
                    }
                    this.parse(field, reps[j], encodingChars);
                    continue;
                }
                catch (HL7Exception e) {
                    e.setFieldPosition(i);
                    if (theRepetition > 1) {
                        e.setSegmentRepetition(theRepetition);
                    }
                    e.setSegmentName(destination.getName());
                    throw e;
                }
            }
        }
        if (destination.getClass().getName().contains("OBX")) {
            Varies.fixOBX5(destination, this.getFactory(), this.getHapiContext().getParserConfiguration());
        }
    }

    private static boolean isDelimDefSegment(String theSegmentName) {
        boolean is = false;
        if (theSegmentName.equals("MSH") || theSegmentName.equals("FHS") || theSegmentName.equals("BHS")) {
            is = true;
        }
        return is;
    }

    @Override
    public void parse(Type destinationField, String data, EncodingCharacters encodingCharacters) throws HL7Exception {
        String[] components = PipeParser.split(data, String.valueOf(encodingCharacters.getComponentSeparator()));
        for (int i = 0; i < components.length; ++i) {
            String[] subcomponents = PipeParser.split(components[i], String.valueOf(encodingCharacters.getSubcomponentSeparator()));
            for (int j = 0; j < subcomponents.length; ++j) {
                String val = subcomponents[j];
                if (val != null) {
                    val = Escape.unescape(val, encodingCharacters);
                }
                Terser.getPrimitive(destinationField, i + 1, j + 1).setValue(val);
            }
        }
    }

    public static String[] split(String composite, String delim) {
        ArrayList<String> components = new ArrayList<String>();
        if (composite == null) {
            composite = "";
        }
        if (delim == null) {
            delim = "";
        }
        StringTokenizer tok = new StringTokenizer(composite, delim, true);
        boolean previousTokenWasDelim = true;
        while (tok.hasMoreTokens()) {
            String thisTok = tok.nextToken();
            if (thisTok.equals(delim)) {
                if (previousTokenWasDelim) {
                    components.add(null);
                }
                previousTokenWasDelim = true;
                continue;
            }
            components.add(thisTok);
            previousTokenWasDelim = false;
        }
        String[] ret = new String[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            ret[i] = (String)components.get(i);
        }
        return ret;
    }

    @Override
    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        return PipeParser.encode(structure, encodingCharacters);
    }

    @Override
    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        return PipeParser.encode(type, encodingCharacters);
    }

    public static String encode(Type source, EncodingCharacters encodingChars) {
        return PipeParser.encode(source, encodingChars, null, null);
    }

    private static String encode(Type source, EncodingCharacters encodingChars, ParserConfiguration parserConfig, String currentTerserPath) {
        Varies varies;
        if (source instanceof Varies && (varies = (Varies)source).getData() != null) {
            source = varies.getData();
        }
        StringBuilder field = new StringBuilder();
        for (int i = 1; i <= Terser.numComponents(source); ++i) {
            StringBuilder comp = new StringBuilder();
            for (int j = 1; j <= Terser.numSubComponents(source, i); ++j) {
                Primitive p = Terser.getPrimitive(source, i, j);
                comp.append(PipeParser.encodePrimitive(p, encodingChars));
                comp.append(encodingChars.getSubcomponentSeparator());
            }
            field.append(PipeParser.stripExtraDelimiters(comp.toString(), encodingChars.getSubcomponentSeparator()));
            field.append(encodingChars.getComponentSeparator());
        }
        int forceUpToFieldNum = 0;
        if (parserConfig != null && currentTerserPath != null) {
            for (String nextPath : parserConfig.getForcedEncode()) {
                if (!nextPath.startsWith(currentTerserPath + "-") || nextPath.length() <= currentTerserPath.length()) continue;
                int endOfFieldDef = nextPath.indexOf(45, currentTerserPath.length());
                if (endOfFieldDef == -1) {
                    forceUpToFieldNum = 0;
                    break;
                }
                String fieldNumString = nextPath.substring(endOfFieldDef + 1, nextPath.length());
                if (fieldNumString.length() <= 0) continue;
                forceUpToFieldNum = Math.max(forceUpToFieldNum, Integer.parseInt(fieldNumString));
            }
        }
        char componentSeparator = encodingChars.getComponentSeparator();
        String retVal = PipeParser.stripExtraDelimiters(field.toString(), componentSeparator);
        while (forceUpToFieldNum > 0 && PipeParser.countInstancesOf(retVal, componentSeparator) + 1 < forceUpToFieldNum) {
            retVal = retVal + componentSeparator;
        }
        return retVal;
    }

    private static String encodePrimitive(Primitive p, EncodingCharacters encodingChars) {
        String val = p.getValue();
        val = val == null ? "" : Escape.escape(val, encodingChars);
        return val;
    }

    private static String stripExtraDelimiters(String in, char delim) {
        char[] chars = in.toCharArray();
        int c = chars.length - 1;
        boolean found = false;
        while (c >= 0 && !found) {
            if (chars[c--] == delim) continue;
            found = true;
        }
        String ret = "";
        if (found) {
            ret = String.valueOf(chars, 0, c + 2);
        }
        return ret;
    }

    @Override
    protected String doEncode(Message source, String encoding) throws HL7Exception {
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("This parser does not support the " + encoding + " encoding");
        }
        return this.encode(source);
    }

    @Override
    protected String doEncode(Message source) throws HL7Exception {
        String encCharString;
        Segment msh = (Segment)source.get("MSH");
        String fieldSepString = Terser.get(msh, 1, 0, 1, 1);
        if (fieldSepString == null) {
            throw new HL7Exception("Can't encode message: MSH-1 (field separator) is missing");
        }
        char fieldSep = '|';
        if (fieldSepString.length() > 0) {
            fieldSep = fieldSepString.charAt(0);
        }
        if ((encCharString = Terser.get(msh, 2, 0, 1, 1)) == null) {
            throw new HL7Exception("Can't encode message: MSH-2 (encoding characters) is missing");
        }
        if (encCharString.length() != 4) {
            throw new HL7Exception("Encoding characters (MSH-2) value '" + encCharString + "' invalid -- must be 4 characters", ErrorCode.DATA_TYPE_ERROR);
        }
        EncodingCharacters en = new EncodingCharacters(fieldSep, encCharString);
        return PipeParser.encode(source, en, this.getParserConfiguration(), "");
    }

    public static String encode(Group source, EncodingCharacters encodingChars) throws HL7Exception {
        return PipeParser.encode(source, encodingChars, source.getMessage().getParser().getParserConfiguration(), "");
    }

    private static String encode(Group source, EncodingCharacters encodingChars, ParserConfiguration parserConfiguration, String currentTerserPath) throws HL7Exception {
        StringBuilder result = new StringBuilder();
        String[] names = source.getNames();
        String firstMandatorySegmentName = null;
        boolean haveEncounteredMandatorySegment = false;
        boolean haveEncounteredContent = false;
        boolean haveHadMandatorySegment = false;
        boolean haveHadSegmentBeforeMandatorySegment = false;
        for (String nextName : names) {
            source.get(nextName, 0);
            Structure[] reps = source.getAll(nextName);
            boolean nextNameIsRequired = source.isRequired(nextName);
            boolean havePreviouslyEncounteredMandatorySegment = haveEncounteredMandatorySegment;
            haveEncounteredMandatorySegment |= nextNameIsRequired;
            if (nextNameIsRequired && !haveHadMandatorySegment && !source.isGroup(nextName)) {
                firstMandatorySegmentName = nextName;
            }
            String nextTerserPath = currentTerserPath.length() > 0 ? currentTerserPath + "/" + nextName : nextName;
            for (Structure rep : reps) {
                if (rep instanceof Group) {
                    String encodedGroup = PipeParser.encode((Group)rep, encodingChars, parserConfiguration, nextTerserPath);
                    result.append(encodedGroup);
                    if (encodedGroup.length() <= 0) continue;
                    if (!haveHadMandatorySegment && !haveEncounteredMandatorySegment) {
                        haveHadSegmentBeforeMandatorySegment = true;
                    }
                    if (nextNameIsRequired && !haveHadMandatorySegment && !havePreviouslyEncounteredMandatorySegment) {
                        haveHadMandatorySegment = true;
                    }
                    haveEncounteredContent = true;
                    continue;
                }
                boolean encodeEmptySegments = parserConfiguration.determineForcedEncodeIncludesTerserPath(nextTerserPath);
                String segString = PipeParser.encode((Segment)rep, encodingChars, parserConfiguration, nextTerserPath);
                if (segString.length() < 4 && !encodeEmptySegments) continue;
                result.append(segString);
                if (segString.length() == 3) {
                    result.append(encodingChars.getFieldSeparator());
                }
                result.append(SEGMENT_DELIMITER);
                haveEncounteredContent = true;
                if (nextNameIsRequired) {
                    haveHadMandatorySegment = true;
                }
                if (haveHadMandatorySegment || haveEncounteredMandatorySegment) continue;
                haveHadSegmentBeforeMandatorySegment = true;
            }
        }
        if (firstMandatorySegmentName != null && !haveHadMandatorySegment && !haveHadSegmentBeforeMandatorySegment && haveEncounteredContent && parserConfiguration.isEncodeEmptyMandatorySegments()) {
            return firstMandatorySegmentName.substring(0, 3) + encodingChars.getFieldSeparator() + SEGMENT_DELIMITER + result;
        }
        return result.toString();
    }

    public static PipeParser getInstanceWithNoValidation() {
        DefaultHapiContext context = new DefaultHapiContext();
        context.setValidationContext((ValidationContext)ValidationContextFactory.noValidation());
        return new PipeParser(context);
    }

    public static String encode(Segment source, EncodingCharacters encodingChars) {
        return PipeParser.encode(source, encodingChars, null, null);
    }

    private static String encode(Segment source, EncodingCharacters encodingChars, ParserConfiguration parserConfig, String currentTerserPath) {
        int offset;
        StringBuilder result = new StringBuilder();
        result.append(source.getName());
        result.append(encodingChars.getFieldSeparator());
        int startAt = 1;
        if (PipeParser.isDelimDefSegment(source.getName())) {
            startAt = 2;
        }
        int numFields = source.numFields();
        int forceUpToFieldNum = 0;
        if (parserConfig != null && currentTerserPath != null) {
            forceUpToFieldNum = parserConfig.determineForcedFieldNumForTerserPath(currentTerserPath);
        }
        numFields = Math.max(numFields, forceUpToFieldNum);
        for (int i = startAt; i <= numFields; ++i) {
            String nextFieldTerserPath = currentTerserPath + "-" + i;
            if (parserConfig != null && currentTerserPath != null) {
                for (String nextPath : parserConfig.getForcedEncode()) {
                    if (!nextPath.startsWith(nextFieldTerserPath + "-")) continue;
                    try {
                        source.getField(i, 0);
                    }
                    catch (HL7Exception e) {
                        log.error("Error while encoding segment: ", (Throwable)e);
                    }
                }
            }
            try {
                Type[] reps = source.getField(i);
                for (int j = 0; j < reps.length; ++j) {
                    String fieldText = PipeParser.encode(reps[j], encodingChars, parserConfig, nextFieldTerserPath);
                    if (PipeParser.isDelimDefSegment(source.getName()) && i == 2) {
                        fieldText = Escape.unescape(fieldText, encodingChars);
                    }
                    result.append(fieldText);
                    if (j >= reps.length - 1) continue;
                    result.append(encodingChars.getRepetitionSeparator());
                }
            }
            catch (HL7Exception e) {
                log.error("Error while encoding segment: ", (Throwable)e);
            }
            result.append(encodingChars.getFieldSeparator());
        }
        char fieldSeparator = encodingChars.getFieldSeparator();
        String retVal = PipeParser.stripExtraDelimiters(result.toString(), fieldSeparator);
        int n = offset = PipeParser.isDelimDefSegment(source.getName()) ? 1 : 0;
        while (forceUpToFieldNum > 0 && PipeParser.countInstancesOf(retVal, fieldSeparator) + offset < forceUpToFieldNum) {
            retVal = retVal + fieldSeparator;
        }
        return retVal;
    }

    private static int countInstancesOf(String theString, char theCharToSearchFor) {
        int retVal = 0;
        for (int i = 0; i < theString.length(); ++i) {
            if (theString.charAt(i) != theCharToSearchFor) continue;
            ++retVal;
        }
        return retVal;
    }

    public static String stripLeadingWhitespace(String in) {
        StringBuilder out = new StringBuilder();
        char[] chars = in.toCharArray();
        for (int c = 0; c < chars.length && Character.isWhitespace(chars[c]); ++c) {
        }
        for (int i = c; i < chars.length; ++i) {
            out.append(chars[i]);
        }
        return out.toString();
    }

    @Override
    public Segment getCriticalResponseData(String message) throws HL7Exception {
        int locStartMSH = message.indexOf("MSH");
        if (locStartMSH < 0) {
            throw new HL7Exception("Couldn't find MSH segment in message: " + message, ErrorCode.SEGMENT_SEQUENCE_ERROR);
        }
        int locEndMSH = message.indexOf(13, locStartMSH + 1);
        if (locEndMSH < 0) {
            locEndMSH = message.length();
        }
        String mshString = message.substring(locStartMSH, locEndMSH);
        char fieldSep = mshString.charAt(3);
        String[] fields = PipeParser.split(mshString, String.valueOf(fieldSep));
        try {
            String encChars = fields[1];
            char compSep = encChars.charAt(0);
            String messControlID = fields[9];
            String[] procIDComps = PipeParser.split(fields[10], String.valueOf(compSep));
            String version = null;
            try {
                version = this.getVersion(message);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (version == null) {
                Version availableVersion = Version.highestAvailableVersionOrDefault();
                version = availableVersion.getVersion();
            }
            Segment msh = Parser.makeControlMSH(version, this.getFactory());
            Terser.set(msh, 1, 0, 1, 1, String.valueOf(fieldSep));
            Terser.set(msh, 2, 0, 1, 1, encChars);
            Terser.set(msh, 10, 0, 1, 1, messControlID);
            Terser.set(msh, 11, 0, 1, 1, procIDComps[0]);
            Terser.set(msh, 12, 0, 1, 1, version);
            return msh;
        }
        catch (Exception e) {
            throw new HL7Exception("Can't parse critical fields from MSH segment (" + e.getClass().getName() + ": " + e.getMessage() + "): " + mshString, ErrorCode.REQUIRED_FIELD_MISSING, (Throwable)e);
        }
    }

    @Override
    public String getAckID(String message) {
        String ackID = null;
        int startMSA = message.indexOf("\rMSA");
        if (startMSA >= 0) {
            int startFieldOne = startMSA + 5;
            char fieldDelim = message.charAt(startFieldOne - 1);
            int start = message.indexOf(fieldDelim, startFieldOne) + 1;
            int end = message.indexOf(fieldDelim, start);
            int segEnd = message.indexOf(String.valueOf(SEGMENT_DELIMITER), start);
            if (segEnd > start && segEnd < end) {
                end = segEnd;
            }
            if (end < 0) {
                end = message.charAt(message.length() - 1) == '\r' ? message.length() - 1 : message.length();
            }
            if (start > 0 && end > start) {
                ackID = message.substring(start, end);
            }
        }
        log.trace("ACK ID: {}", ackID);
        return ackID;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.myLegacyMode = legacyMode;
    }

    @Override
    public String encode(Message source) throws HL7Exception {
        if (this.myLegacyMode != null && this.myLegacyMode.booleanValue()) {
            OldPipeParser oldPipeParser = new OldPipeParser(this.getFactory());
            return oldPipeParser.encode(source);
        }
        return super.encode(source);
    }

    @Override
    public Message parse(String message) throws HL7Exception {
        if (this.myLegacyMode != null && this.myLegacyMode.booleanValue()) {
            OldPipeParser oldPipeParser = new OldPipeParser(this.getFactory());
            return oldPipeParser.parse(message);
        }
        return super.parse(message);
    }

    public boolean isLegacyMode() {
        if (this.myLegacyMode == null) {
            return Boolean.parseBoolean(System.getProperty(DEFAULT_LEGACY_MODE_PROPERTY));
        }
        return this.myLegacyMode;
    }

    @Override
    public String getVersion(String message) throws HL7Exception {
        String[] comp;
        String msh;
        int startMSH = message.indexOf("MSH");
        int endMSH = message.indexOf(SEGMENT_DELIMITER, startMSH);
        if (endMSH < 0) {
            endMSH = message.length();
        }
        if ((msh = message.substring(startMSH, endMSH)).length() <= 3) {
            throw new HL7Exception("Can't find field separator in MSH: " + msh, ErrorCode.UNSUPPORTED_VERSION_ID);
        }
        String fieldSep = String.valueOf(msh.charAt(3));
        String[] fields = PipeParser.split(msh, fieldSep);
        if (fields.length < 2 || fields[1] == null || fields[1].length() != 4) {
            throw new HL7Exception("Invalid or incomplete encoding characters - MSH-2 is " + fields[1], ErrorCode.REQUIRED_FIELD_MISSING);
        }
        String compSep = String.valueOf(fields[1].charAt(0));
        if (fields.length >= 12) {
            comp = PipeParser.split(fields[11], compSep);
            if (comp.length < 1) {
                throw new HL7Exception("Can't find version ID - MSH.12 is " + fields[11], ErrorCode.REQUIRED_FIELD_MISSING);
            }
        } else {
            if (this.getParserConfiguration().isAllowUnknownVersions()) {
                return Version.highestAvailableVersionOrDefault().getVersion();
            }
            throw new HL7Exception("Can't find version ID - MSH has only " + fields.length + " fields.", ErrorCode.REQUIRED_FIELD_MISSING);
        }
        String version = comp[0];
        return version;
    }

    @Override
    public void parse(Message message, String string) throws HL7Exception {
        if (message instanceof AbstractSuperMessage && message.getName() == null) {
            String structure = this.getStructure((String)string).messageStructure;
            ((AbstractSuperMessage)message).setName(structure);
        }
        IStructureDefinition structureDef = this.getStructureDefinition(message);
        MessageIterator messageIter = new MessageIterator(message, structureDef, "MSH", true);
        String[] segments = PipeParser.split(string, SEGMENT_DELIMITER);
        if (segments.length == 0) {
            throw new HL7Exception("Invalid message content: \"" + string + "\"");
        }
        if (segments[0] == null || segments[0].length() < 4) {
            throw new HL7Exception("Invalid message content: \"" + string + "\"");
        }
        int delim = 124;
        String prevName = null;
        int repNum = 1;
        for (int i = 0; i < segments.length; ++i) {
            String name;
            if (segments[i] != null && segments[i].length() > 0 && Character.isWhitespace(segments[i].charAt(0))) {
                segments[i] = PipeParser.stripLeadingWhitespace(segments[i]);
            }
            if (segments[i] == null || segments[i].length() < 3) continue;
            if (i == 0) {
                if (segments[i].length() < 4) {
                    throw new HL7Exception("Invalid message content: \"" + string + "\"");
                }
                name = segments[i].substring(0, 3);
                delim = segments[i].charAt(3);
            } else {
                name = segments[i].indexOf(delim) >= 0 ? segments[i].substring(0, segments[i].indexOf(delim)) : segments[i];
            }
            log.trace("Parsing segment {}", (Object)name);
            if (name.equals(prevName)) {
                ++repNum;
            } else {
                repNum = 1;
                prevName = name;
            }
            messageIter.setDirection(name);
            try {
                if (!messageIter.hasNext()) continue;
                Segment next = (Segment)messageIter.next();
                this.parse(next, segments[i], PipeParser.getEncodingChars(string), repNum);
                continue;
            }
            catch (Error e) {
                if (e.getCause() instanceof HL7Exception) {
                    throw (HL7Exception)e.getCause();
                }
                throw e;
            }
        }
        this.applySuperStructureName(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Holder<T> {
        private T myObject;

        private Holder() {
        }

        public T getObject() {
            return this.myObject;
        }

        public void setObject(T theObject) {
            this.myObject = theObject;
        }
    }

    private static class MessageStructure {
        public String messageStructure;
        public boolean explicitlyDefined;

        public MessageStructure(String theMessageStructure, boolean isExplicitlyDefined) {
            this.messageStructure = theMessageStructure;
            this.explicitlyDefined = isExplicitlyDefined;
        }
    }
}

