/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_DTN;
import ca.uhn.hl7v2.model.v22.datatype.CM_PCF;
import ca.uhn.hl7v2.model.v22.datatype.CM_PEN;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN3
extends AbstractSegment {
    public IN3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - insurance certification");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Certification number");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Certified by");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Certification required");
            this.add(CM_PEN.class, false, 1, 10, new Object[]{this.getMessage()}, "Penalty");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Certification date / time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Certification modify date / time");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Operator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Certification begin date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Certification end date");
            this.add(CM_DTN.class, false, 1, 3, new Object[]{this.getMessage()}, "Days");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Non-concur code / description");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Non-concur effective date / time");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Physician reviewer");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Certification contact");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Certification contact phone number");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Appeal reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Certification agency");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Certification agency phone number");
            this.add(CM_PCF.class, false, 0, 40, new Object[]{this.getMessage()}, "Pre-certification required / window");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Case manager");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Second opinion date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(151)}, "Second opinion status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(152)}, "Second opinion documentation received");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Second opinion practitioner");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IN3 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDInsuranceCertification() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn31_SetIDInsuranceCertification() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getCertificationNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getIn32_CertificationNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public CN getCertifiedBy() {
        CN retVal = (CN)this.getTypedField(3, 0);
        return retVal;
    }

    public CN getIn33_CertifiedBy() {
        CN retVal = (CN)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getCertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getIn34_CertificationRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CM_PEN getPenalty() {
        CM_PEN retVal = (CM_PEN)this.getTypedField(5, 0);
        return retVal;
    }

    public CM_PEN getIn35_Penalty() {
        CM_PEN retVal = (CM_PEN)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getCertificationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getIn36_CertificationDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getCertificationModifyDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getIn37_CertificationModifyDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getOperator() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN getIn38_Operator() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getCertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getIn39_CertificationBeginDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getCertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getIn310_CertificationEndDate() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_DTN getDays() {
        CM_DTN retVal = (CM_DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_DTN getIn311_Days() {
        CM_DTN retVal = (CM_DTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getNonConcurCodeDescription() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getIn312_NonConcurCodeDescription() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getNonConcurEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getIn313_NonConcurEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public CN getPhysicianReviewer() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public CN getIn314_PhysicianReviewer() {
        CN retVal = (CN)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getCertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getIn315_CertificationContact() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public TN[] getCertificationContactPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(16, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getIn316_CertificationContactPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(16, (Type[])new TN[0]);
        return retVal;
    }

    public int getCertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public TN getCertificationContactPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(16, rep);
        return retVal;
    }

    public TN getIn316_CertificationContactPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getIn316_CertificationContactPhoneNumberReps() {
        return this.getReps(16);
    }

    public TN insertCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(16, rep);
    }

    public TN insertIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(16, rep);
    }

    public TN removeCertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(16, rep);
    }

    public TN removeIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(16, rep);
    }

    public CE getAppealReason() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getIn317_AppealReason() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getCertificationAgency() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getIn318_CertificationAgency() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public TN[] getCertificationAgencyPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(19, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getIn319_CertificationAgencyPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(19, (Type[])new TN[0]);
        return retVal;
    }

    public int getCertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public TN getCertificationAgencyPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(19, rep);
        return retVal;
    }

    public TN getIn319_CertificationAgencyPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(19, rep);
        return retVal;
    }

    public int getIn319_CertificationAgencyPhoneNumberReps() {
        return this.getReps(19);
    }

    public TN insertCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(19, rep);
    }

    public TN insertIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(19, rep);
    }

    public TN removeCertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(19, rep);
    }

    public TN removeIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(19, rep);
    }

    public CM_PCF[] getPreCertificationRequiredWindow() {
        CM_PCF[] retVal = (CM_PCF[])this.getTypedField(20, (Type[])new CM_PCF[0]);
        return retVal;
    }

    public CM_PCF[] getIn320_PreCertificationRequiredWindow() {
        CM_PCF[] retVal = (CM_PCF[])this.getTypedField(20, (Type[])new CM_PCF[0]);
        return retVal;
    }

    public int getPreCertificationRequiredWindowReps() {
        return this.getReps(20);
    }

    public CM_PCF getPreCertificationRequiredWindow(int rep) {
        CM_PCF retVal = (CM_PCF)this.getTypedField(20, rep);
        return retVal;
    }

    public CM_PCF getIn320_PreCertificationRequiredWindow(int rep) {
        CM_PCF retVal = (CM_PCF)this.getTypedField(20, rep);
        return retVal;
    }

    public int getIn320_PreCertificationRequiredWindowReps() {
        return this.getReps(20);
    }

    public CM_PCF insertPreCertificationRequiredWindow(int rep) throws HL7Exception {
        return (CM_PCF)super.insertRepetition(20, rep);
    }

    public CM_PCF insertIn320_PreCertificationRequiredWindow(int rep) throws HL7Exception {
        return (CM_PCF)super.insertRepetition(20, rep);
    }

    public CM_PCF removePreCertificationRequiredWindow(int rep) throws HL7Exception {
        return (CM_PCF)super.removeRepetition(20, rep);
    }

    public CM_PCF removeIn320_PreCertificationRequiredWindow(int rep) throws HL7Exception {
        return (CM_PCF)super.removeRepetition(20, rep);
    }

    public ST getCaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getIn321_CaseManager() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public DT getSecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public DT getIn322_SecondOpinionDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getSecondOpinionStatus() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getIn323_SecondOpinionStatus() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getSecondOpinionDocumentationReceived() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getIn324_SecondOpinionDocumentationReceived() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public CN getSecondOpinionPractitioner() {
        CN retVal = (CN)this.getTypedField(25, 0);
        return retVal;
    }

    public CN getIn325_SecondOpinionPractitioner() {
        CN retVal = (CN)this.getTypedField(25, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CM_PEN(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new CN(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
            case 10: {
                return new CM_DTN(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new CN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new TN(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new TN(this.getMessage());
            }
            case 19: {
                return new CM_PCF(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new DT(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(151));
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(152));
            }
            case 24: {
                return new CN(this.getMessage());
            }
        }
        return null;
    }
}

