/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RCI_I05_RESULTS;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RCI_I05_OBSERVATION
extends AbstractGroup {
    public RCI_I05_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RCI_I05_RESULTS.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RCI_I05_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RCI_I05_RESULTS getRESULTS() {
        RCI_I05_RESULTS retVal = (RCI_I05_RESULTS)this.getTyped("RESULTS", RCI_I05_RESULTS.class);
        return retVal;
    }

    public RCI_I05_RESULTS getRESULTS(int rep) {
        RCI_I05_RESULTS retVal = (RCI_I05_RESULTS)this.getTyped("RESULTS", rep, RCI_I05_RESULTS.class);
        return retVal;
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RCI_I05_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RCI_I05_RESULTS.class);
    }

    public void insertRESULTS(RCI_I05_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", (Structure)structure, rep);
    }

    public RCI_I05_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RCI_I05_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RCI_I05_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RCI_I05_RESULTS)super.removeRepetition("RESULTS", rep);
    }
}

