/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RAR_RAR_DEFINITION;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAR_RAR
extends AbstractMessage {
    public RAR_RAR() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RAR_RAR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(RAR_RAR_DEFINITION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAR_RAR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public RAR_RAR_DEFINITION getDEFINITION() {
        return (RAR_RAR_DEFINITION)this.getTyped("DEFINITION", RAR_RAR_DEFINITION.class);
    }

    public RAR_RAR_DEFINITION getDEFINITION(int rep) {
        return (RAR_RAR_DEFINITION)this.getTyped("DEFINITION", rep, RAR_RAR_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RAR_RAR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RAR_RAR_DEFINITION.class);
    }

    public void insertDEFINITION(RAR_RAR_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", (Structure)structure, rep);
    }

    public RAR_RAR_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RAR_RAR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RAR_RAR_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RAR_RAR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

