/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LOC
extends AbstractSegment {
    public LOC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 20, new Object[]{this.getMessage()}, "Primary Key Value");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Location Description");
            this.add(IS.class, true, 0, 2, new Object[]{this.getMessage(), new Integer(260)}, "Location Type");
            this.add(XON.class, false, 1, 90, new Object[]{this.getMessage()}, "Organization Name");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Location Address");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Location Phone");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "License Number");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(261)}, "Location Equipment");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating LOC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLoc1_PrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getLocationDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getLoc2_LocationDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public IS[] getLocationType() {
        IS[] retVal = (IS[])this.getTypedField(3, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getLoc3_LocationType() {
        IS[] retVal = (IS[])this.getTypedField(3, (Type[])new IS[0]);
        return retVal;
    }

    public int getLocationTypeReps() {
        return this.getReps(3);
    }

    public IS getLocationType(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public IS getLoc3_LocationType(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLoc3_LocationTypeReps() {
        return this.getReps(3);
    }

    public IS insertLocationType(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS insertLoc3_LocationType(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS removeLocationType(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public IS removeLoc3_LocationType(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public XON getOrganizationName() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XON getLoc4_OrganizationName() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XAD getLocationAddress() {
        XAD retVal = (XAD)this.getTypedField(5, 0);
        return retVal;
    }

    public XAD getLoc5_LocationAddress() {
        XAD retVal = (XAD)this.getTypedField(5, 0);
        return retVal;
    }

    public XTN[] getLocationPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(6, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getLoc6_LocationPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(6, (Type[])new XTN[0]);
        return retVal;
    }

    public int getLocationPhoneReps() {
        return this.getReps(6);
    }

    public XTN getLocationPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public XTN getLoc6_LocationPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getLoc6_LocationPhoneReps() {
        return this.getReps(6);
    }

    public XTN insertLocationPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertLoc6_LocationPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeLocationPhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeLoc6_LocationPhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public CE[] getLicenseNumber() {
        CE[] retVal = (CE[])this.getTypedField(7, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getLoc7_LicenseNumber() {
        CE[] retVal = (CE[])this.getTypedField(7, (Type[])new CE[0]);
        return retVal;
    }

    public int getLicenseNumberReps() {
        return this.getReps(7);
    }

    public CE getLicenseNumber(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public CE getLoc7_LicenseNumber(int rep) {
        CE retVal = (CE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getLoc7_LicenseNumberReps() {
        return this.getReps(7);
    }

    public CE insertLicenseNumber(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertLoc7_LicenseNumber(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeLicenseNumber(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeLoc7_LicenseNumber(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public ID[] getLocationEquipment() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getLoc8_LocationEquipment() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public int getLocationEquipmentReps() {
        return this.getReps(8);
    }

    public ID getLocationEquipment(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public ID getLoc8_LocationEquipment(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public int getLoc8_LocationEquipmentReps() {
        return this.getReps(8);
    }

    public ID insertLocationEquipment(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertLoc8_LocationEquipment(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeLocationEquipment(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removeLoc8_LocationEquipment(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(260));
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(261));
            }
        }
        return null;
    }
}

