/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.FT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PEO
extends AbstractSegment {
    public PEO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Event Identifiers Used");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Event Symptom/Diagnosis Code");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Event Onset Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Event Exacerbation Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Event Improved Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Event Ended Data/Time");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Event Location Occurred Address");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(237)}, "Event Qualification");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(238)}, "Event Serious");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(239)}, "Event Expected");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(240)}, "Event Outcome");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(241)}, "Patient Outcome");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Event Description From Others");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Event From Original Reporter");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Event Description From Patient");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Event Description From Practitioner");
            this.add(FT.class, false, 0, 600, new Object[]{this.getMessage()}, "Event Description From Autopsy");
            this.add(CE.class, false, 0, 30, new Object[]{this.getMessage()}, "Cause Of Death");
            this.add(XPN.class, false, 1, 46, new Object[]{this.getMessage()}, "Primary Observer Name");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Primary Observer Address");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Primary Observer Telephone");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(242)}, "Primary Observer\u2019s Qualification");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(242)}, "Confirmation Provided By");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Primary Observer Aware Date/Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(243)}, "Primary Observer\u2019s Identity May Be Divulged");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PEO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE[] getEventIdentifiersUsed() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPeo1_EventIdentifiersUsed() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public int getEventIdentifiersUsedReps() {
        return this.getReps(1);
    }

    public CE getEventIdentifiersUsed(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public CE getPeo1_EventIdentifiersUsed(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPeo1_EventIdentifiersUsedReps() {
        return this.getReps(1);
    }

    public CE insertEventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE insertPeo1_EventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE removeEventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE removePeo1_EventIdentifiersUsed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE[] getEventSymptomDiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(2, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPeo2_EventSymptomDiagnosisCode() {
        CE[] retVal = (CE[])this.getTypedField(2, (Type[])new CE[0]);
        return retVal;
    }

    public int getEventSymptomDiagnosisCodeReps() {
        return this.getReps(2);
    }

    public CE getEventSymptomDiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getPeo2_EventSymptomDiagnosisCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPeo2_EventSymptomDiagnosisCodeReps() {
        return this.getReps(2);
    }

    public CE insertEventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeEventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public TS getEventOnsetDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getPeo3_EventOnsetDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEventExacerbationDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getPeo4_EventExacerbationDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getEventImprovedDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getPeo5_EventImprovedDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getEventEndedDataTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getPeo6_EventEndedDataTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public XAD getEventLocationOccurredAddress() {
        XAD retVal = (XAD)this.getTypedField(7, 0);
        return retVal;
    }

    public XAD getPeo7_EventLocationOccurredAddress() {
        XAD retVal = (XAD)this.getTypedField(7, 0);
        return retVal;
    }

    public ID[] getEventQualification() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPeo8_EventQualification() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public int getEventQualificationReps() {
        return this.getReps(8);
    }

    public ID getEventQualification(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public ID getPeo8_EventQualification(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPeo8_EventQualificationReps() {
        return this.getReps(8);
    }

    public ID insertEventQualification(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertPeo8_EventQualification(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeEventQualification(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removePeo8_EventQualification(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID getEventSerious() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPeo9_EventSerious() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getEventExpected() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPeo10_EventExpected() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID[] getEventOutcome() {
        ID[] retVal = (ID[])this.getTypedField(11, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPeo11_EventOutcome() {
        ID[] retVal = (ID[])this.getTypedField(11, (Type[])new ID[0]);
        return retVal;
    }

    public int getEventOutcomeReps() {
        return this.getReps(11);
    }

    public ID getEventOutcome(int rep) {
        ID retVal = (ID)this.getTypedField(11, rep);
        return retVal;
    }

    public ID getPeo11_EventOutcome(int rep) {
        ID retVal = (ID)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPeo11_EventOutcomeReps() {
        return this.getReps(11);
    }

    public ID insertEventOutcome(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID insertPeo11_EventOutcome(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(11, rep);
    }

    public ID removeEventOutcome(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID removePeo11_EventOutcome(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(11, rep);
    }

    public ID getPatientOutcome() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPeo12_PatientOutcome() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public FT[] getEventDescriptionFromOthers() {
        FT[] retVal = (FT[])this.getTypedField(13, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPeo13_EventDescriptionFromOthers() {
        FT[] retVal = (FT[])this.getTypedField(13, (Type[])new FT[0]);
        return retVal;
    }

    public int getEventDescriptionFromOthersReps() {
        return this.getReps(13);
    }

    public FT getEventDescriptionFromOthers(int rep) {
        FT retVal = (FT)this.getTypedField(13, rep);
        return retVal;
    }

    public FT getPeo13_EventDescriptionFromOthers(int rep) {
        FT retVal = (FT)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPeo13_EventDescriptionFromOthersReps() {
        return this.getReps(13);
    }

    public FT insertEventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(13, rep);
    }

    public FT insertPeo13_EventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(13, rep);
    }

    public FT removeEventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(13, rep);
    }

    public FT removePeo13_EventDescriptionFromOthers(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(13, rep);
    }

    public FT[] getEventFromOriginalReporter() {
        FT[] retVal = (FT[])this.getTypedField(14, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPeo14_EventFromOriginalReporter() {
        FT[] retVal = (FT[])this.getTypedField(14, (Type[])new FT[0]);
        return retVal;
    }

    public int getEventFromOriginalReporterReps() {
        return this.getReps(14);
    }

    public FT getEventFromOriginalReporter(int rep) {
        FT retVal = (FT)this.getTypedField(14, rep);
        return retVal;
    }

    public FT getPeo14_EventFromOriginalReporter(int rep) {
        FT retVal = (FT)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPeo14_EventFromOriginalReporterReps() {
        return this.getReps(14);
    }

    public FT insertEventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(14, rep);
    }

    public FT insertPeo14_EventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(14, rep);
    }

    public FT removeEventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(14, rep);
    }

    public FT removePeo14_EventFromOriginalReporter(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(14, rep);
    }

    public FT[] getEventDescriptionFromPatient() {
        FT[] retVal = (FT[])this.getTypedField(15, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPeo15_EventDescriptionFromPatient() {
        FT[] retVal = (FT[])this.getTypedField(15, (Type[])new FT[0]);
        return retVal;
    }

    public int getEventDescriptionFromPatientReps() {
        return this.getReps(15);
    }

    public FT getEventDescriptionFromPatient(int rep) {
        FT retVal = (FT)this.getTypedField(15, rep);
        return retVal;
    }

    public FT getPeo15_EventDescriptionFromPatient(int rep) {
        FT retVal = (FT)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPeo15_EventDescriptionFromPatientReps() {
        return this.getReps(15);
    }

    public FT insertEventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(15, rep);
    }

    public FT insertPeo15_EventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(15, rep);
    }

    public FT removeEventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(15, rep);
    }

    public FT removePeo15_EventDescriptionFromPatient(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(15, rep);
    }

    public FT[] getEventDescriptionFromPractitioner() {
        FT[] retVal = (FT[])this.getTypedField(16, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPeo16_EventDescriptionFromPractitioner() {
        FT[] retVal = (FT[])this.getTypedField(16, (Type[])new FT[0]);
        return retVal;
    }

    public int getEventDescriptionFromPractitionerReps() {
        return this.getReps(16);
    }

    public FT getEventDescriptionFromPractitioner(int rep) {
        FT retVal = (FT)this.getTypedField(16, rep);
        return retVal;
    }

    public FT getPeo16_EventDescriptionFromPractitioner(int rep) {
        FT retVal = (FT)this.getTypedField(16, rep);
        return retVal;
    }

    public int getPeo16_EventDescriptionFromPractitionerReps() {
        return this.getReps(16);
    }

    public FT insertEventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(16, rep);
    }

    public FT insertPeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(16, rep);
    }

    public FT removeEventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(16, rep);
    }

    public FT removePeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(16, rep);
    }

    public FT[] getEventDescriptionFromAutopsy() {
        FT[] retVal = (FT[])this.getTypedField(17, (Type[])new FT[0]);
        return retVal;
    }

    public FT[] getPeo17_EventDescriptionFromAutopsy() {
        FT[] retVal = (FT[])this.getTypedField(17, (Type[])new FT[0]);
        return retVal;
    }

    public int getEventDescriptionFromAutopsyReps() {
        return this.getReps(17);
    }

    public FT getEventDescriptionFromAutopsy(int rep) {
        FT retVal = (FT)this.getTypedField(17, rep);
        return retVal;
    }

    public FT getPeo17_EventDescriptionFromAutopsy(int rep) {
        FT retVal = (FT)this.getTypedField(17, rep);
        return retVal;
    }

    public int getPeo17_EventDescriptionFromAutopsyReps() {
        return this.getReps(17);
    }

    public FT insertEventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(17, rep);
    }

    public FT insertPeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.insertRepetition(17, rep);
    }

    public FT removeEventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(17, rep);
    }

    public FT removePeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception {
        return (FT)super.removeRepetition(17, rep);
    }

    public CE[] getCauseOfDeath() {
        CE[] retVal = (CE[])this.getTypedField(18, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPeo18_CauseOfDeath() {
        CE[] retVal = (CE[])this.getTypedField(18, (Type[])new CE[0]);
        return retVal;
    }

    public int getCauseOfDeathReps() {
        return this.getReps(18);
    }

    public CE getCauseOfDeath(int rep) {
        CE retVal = (CE)this.getTypedField(18, rep);
        return retVal;
    }

    public CE getPeo18_CauseOfDeath(int rep) {
        CE retVal = (CE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getPeo18_CauseOfDeathReps() {
        return this.getReps(18);
    }

    public CE insertCauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE insertPeo18_CauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(18, rep);
    }

    public CE removeCauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public CE removePeo18_CauseOfDeath(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(18, rep);
    }

    public XPN getPrimaryObserverName() {
        XPN retVal = (XPN)this.getTypedField(19, 0);
        return retVal;
    }

    public XPN getPeo19_PrimaryObserverName() {
        XPN retVal = (XPN)this.getTypedField(19, 0);
        return retVal;
    }

    public XAD[] getPrimaryObserverAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(20, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getPeo20_PrimaryObserverAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(20, (Type[])new XAD[0]);
        return retVal;
    }

    public int getPrimaryObserverAddressReps() {
        return this.getReps(20);
    }

    public XAD getPrimaryObserverAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(20, rep);
        return retVal;
    }

    public XAD getPeo20_PrimaryObserverAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(20, rep);
        return retVal;
    }

    public int getPeo20_PrimaryObserverAddressReps() {
        return this.getReps(20);
    }

    public XAD insertPrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(20, rep);
    }

    public XAD insertPeo20_PrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(20, rep);
    }

    public XAD removePrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(20, rep);
    }

    public XAD removePeo20_PrimaryObserverAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(20, rep);
    }

    public XTN[] getPrimaryObserverTelephone() {
        XTN[] retVal = (XTN[])this.getTypedField(21, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getPeo21_PrimaryObserverTelephone() {
        XTN[] retVal = (XTN[])this.getTypedField(21, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPrimaryObserverTelephoneReps() {
        return this.getReps(21);
    }

    public XTN getPrimaryObserverTelephone(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public XTN getPeo21_PrimaryObserverTelephone(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getPeo21_PrimaryObserverTelephoneReps() {
        return this.getReps(21);
    }

    public XTN insertPrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN insertPeo21_PrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN removePrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public XTN removePeo21_PrimaryObserverTelephone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public ID getPrimaryObserverSQualification() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPeo22_PrimaryObserverSQualification() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getConfirmationProvidedBy() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getPeo23_ConfirmationProvidedBy() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public TS getPrimaryObserverAwareDateTime() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public TS getPeo24_PrimaryObserverAwareDateTime() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getPrimaryObserverSIdentityMayBeDivulged() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getPeo25_PrimaryObserverSIdentityMayBeDivulged() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new XAD(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(237));
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(238));
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(239));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(240));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(241));
            }
            case 12: {
                return new FT(this.getMessage());
            }
            case 13: {
                return new FT(this.getMessage());
            }
            case 14: {
                return new FT(this.getMessage());
            }
            case 15: {
                return new FT(this.getMessage());
            }
            case 16: {
                return new FT(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new XPN(this.getMessage());
            }
            case 19: {
                return new XAD(this.getMessage());
            }
            case 20: {
                return new XTN(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(242));
            }
            case 23: {
                return new TS(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(243));
            }
        }
        return null;
    }
}

