/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_PI;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRD
extends AbstractSegment {
    public PRD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 0, 200, new Object[]{this.getMessage()}, "Role");
            this.add(XPN.class, false, 0, 106, new Object[]{this.getMessage()}, "Provider Name");
            this.add(XAD.class, false, 1, 60, new Object[]{this.getMessage()}, "Provider Address");
            this.add(PL.class, false, 1, 60, new Object[]{this.getMessage()}, "Provider Location");
            this.add(XTN.class, false, 0, 20, new Object[]{this.getMessage()}, "Provider Communication Information");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Preferred Method of Contact");
            this.add(CM_PI.class, false, 0, 100, new Object[]{this.getMessage()}, "Provider Identifiers");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Start Date of Role");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective End Date of Role");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PRD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE[] getRole() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getPrd1_Role() {
        CE[] retVal = (CE[])this.getTypedField(1, (Type[])new CE[0]);
        return retVal;
    }

    public int getRoleReps() {
        return this.getReps(1);
    }

    public CE getRole(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public CE getPrd1_Role(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPrd1_RoleReps() {
        return this.getReps(1);
    }

    public CE insertRole(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE insertPrd1_Role(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE removeRole(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE removePrd1_Role(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public XPN[] getProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getPrd2_ProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, (Type[])new XPN[0]);
        return retVal;
    }

    public int getProviderNameReps() {
        return this.getReps(2);
    }

    public XPN getProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public XPN getPrd2_ProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPrd2_ProviderNameReps() {
        return this.getReps(2);
    }

    public XPN insertProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertPrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removePrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XAD getProviderAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public XAD getPrd3_ProviderAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public PL getProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public PL getPrd4_ProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN[] getProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getPrd5_ProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, (Type[])new XTN[0]);
        return retVal;
    }

    public int getProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN getProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public XTN getPrd5_ProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrd5_ProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN insertProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertPrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removeProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removePrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public CE getPreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getPrd6_PreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CM_PI[] getProviderIdentifiers() {
        CM_PI[] retVal = (CM_PI[])this.getTypedField(7, (Type[])new CM_PI[0]);
        return retVal;
    }

    public CM_PI[] getPrd7_ProviderIdentifiers() {
        CM_PI[] retVal = (CM_PI[])this.getTypedField(7, (Type[])new CM_PI[0]);
        return retVal;
    }

    public int getProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public CM_PI getProviderIdentifiers(int rep) {
        CM_PI retVal = (CM_PI)this.getTypedField(7, rep);
        return retVal;
    }

    public CM_PI getPrd7_ProviderIdentifiers(int rep) {
        CM_PI retVal = (CM_PI)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPrd7_ProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public CM_PI insertProviderIdentifiers(int rep) throws HL7Exception {
        return (CM_PI)super.insertRepetition(7, rep);
    }

    public CM_PI insertPrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (CM_PI)super.insertRepetition(7, rep);
    }

    public CM_PI removeProviderIdentifiers(int rep) throws HL7Exception {
        return (CM_PI)super.removeRepetition(7, rep);
    }

    public CM_PI removePrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (CM_PI)super.removeRepetition(7, rep);
    }

    public TS getEffectiveStartDateOfRole() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getPrd8_EffectiveStartDateOfRole() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getEffectiveEndDateOfRole() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getPrd9_EffectiveEndDateOfRole() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new PL(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CM_PI(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

