/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.VXR_V03_OBSERVATION;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXA;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXR_V03_ORDER
extends AbstractGroup {
    public VXR_V03_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(RXA.class, true, false, false);
            this.add(RXR.class, false, false, false);
            this.add(VXR_V03_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VXR_V03_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RXA getRXA() {
        RXA retVal = (RXA)this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public VXR_V03_OBSERVATION getOBSERVATION() {
        VXR_V03_OBSERVATION retVal = (VXR_V03_OBSERVATION)this.getTyped("OBSERVATION", VXR_V03_OBSERVATION.class);
        return retVal;
    }

    public VXR_V03_OBSERVATION getOBSERVATION(int rep) {
        VXR_V03_OBSERVATION retVal = (VXR_V03_OBSERVATION)this.getTyped("OBSERVATION", rep, VXR_V03_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<VXR_V03_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", VXR_V03_OBSERVATION.class);
    }

    public void insertOBSERVATION(VXR_V03_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public VXR_V03_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (VXR_V03_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public VXR_V03_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (VXR_V03_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

