/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.deployment.WarArchive;
import org.apache.cactus.integration.ant.deployment.WebXml;
import org.apache.cactus.integration.ant.deployment.WebXmlIo;
import org.apache.cactus.integration.ant.deployment.WebXmlMerger;
import org.apache.cactus.integration.ant.deployment.WebXmlVersion;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CactifyWarTask
extends War {
    private static final String FILTER_REDIRECTOR_CLASS = "org.apache.cactus.server.FilterTestRedirector";
    private static final String DEFAULT_FILTER_REDIRECTOR_MAPPING = "/FilterRedirector";
    private static final String DEFAULT_JSP_REDIRECTOR_MAPPING = "/JspRedirector";
    private static final String SERVLET_REDIRECTOR_CLASS = "org.apache.cactus.server.ServletTestRedirector";
    private static final String DEFAULT_SERVLET_REDIRECTOR_MAPPING = "/ServletRedirector";
    private File srcFile;
    private File mergeWebXml;
    private Redirector filterRedirector;
    private Redirector jspRedirector;
    private Redirector servletRedirector;
    private XMLCatalog xmlCatalog = null;
    private String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        WebXml webXml = null;
        if (this.srcFile != null) {
            ZipFileSet currentFiles = new ZipFileSet();
            currentFiles.setSrc(this.srcFile);
            currentFiles.createExclude().setName("WEB-INF/web.xml");
            this.addZipfileset(currentFiles);
            webXml = this.getOriginalWebXml();
        } else {
            if (this.version == null) {
                throw new BuildException("You need to specify either the [srcfile] or the [version] attribute");
            }
            WebXmlVersion webXmlVersion = null;
            webXmlVersion = this.version.equals("2.2") ? WebXmlVersion.V2_2 : WebXmlVersion.V2_3;
            try {
                webXml = WebXmlIo.newWebXml(webXmlVersion);
            }
            catch (ParserConfigurationException pce) {
                throw new BuildException("Could not create deployment descriptor", (Throwable)pce);
            }
        }
        File tmpWebXml = this.cactifyWebXml(webXml);
        this.setWebxml(tmpWebXml);
        this.addCactusJars();
        try {
            super.execute();
        }
        finally {
            tmpWebXml.delete();
        }
    }

    public void addFilterRedirector(Redirector theFilterRedirector) {
        this.filterRedirector = theFilterRedirector;
    }

    public void addJspRedirector(Redirector theJspRedirector) {
        this.jspRedirector = theJspRedirector;
    }

    public void addServletRedirector(Redirector theServletRedirector) {
        this.servletRedirector = theServletRedirector;
    }

    public final void addConfiguredXMLCatalog(XMLCatalog theXmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(theXmlCatalog);
    }

    public final void setMergeWebXml(File theMergeFile) {
        this.mergeWebXml = theMergeFile;
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public final void setVersion(Version theVersion) {
        this.version = theVersion.getValue();
    }

    private void addCactusJars() {
        this.addJarWithClass("org.aspectj.lang.JoinPoint", "AspectJ Runtime");
        this.addJarWithClass("org.apache.cactus.ServletTestCase", "Cactus Framework");
        this.addJarWithClass("org.apache.commons.logging.Log", "Commons-Logging");
        this.addJarWithClass("org.apache.commons.httpclient.HttpClient", "Commons-HttpClient");
        this.addJarWithClass("junit.framework.TestCase", "JUnit");
    }

    private void addJarWithClass(String theClassName, String theDescription) {
        String resourceName = "/" + theClassName.replace('.', '/') + ".class";
        ZipFileSet jar = new ZipFileSet();
        File file = ResourceUtils.getResourceLocation(resourceName);
        if (file != null) {
            jar.setFile(file);
            this.addLib(jar);
        } else {
            this.log("Could not find the " + theDescription + " JAR", 1);
            this.log("You need to add the JAR to the classpath of the task", 2);
            this.log("(Searched for class " + theClassName + ")", 4);
        }
    }

    private void addJspRedirector() {
        File jspRedirectorFile = new File(new File(System.getProperty("java.io.tmpdir")), "jspRedirector.jsp");
        jspRedirectorFile.deleteOnExit();
        try {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/server/jspRedirector.jsp", jspRedirectorFile);
        }
        catch (IOException e) {
            this.log("Could not copy the JSP redirector (" + e.getMessage() + ")", 1);
        }
        FileSet fileSet = new FileSet();
        fileSet.setFile(jspRedirectorFile);
        this.addFileset(fileSet);
    }

    private File cactifyWebXml(WebXml theWebXml) {
        WebXml redirectorsWebXml = this.getPrototypeWebXml(theWebXml);
        WebXmlMerger merger = new WebXmlMerger(theWebXml);
        merger.setLog(new AntLog((Task)this));
        merger.merge(redirectorsWebXml);
        this.addJspRedirector();
        if (this.mergeWebXml != null) {
            try {
                WebXml parsedMergeWebXml = WebXmlIo.parseWebXmlFromFile(this.mergeWebXml, (EntityResolver)this.xmlCatalog);
                merger = new WebXmlMerger(theWebXml);
                merger.setLog(new AntLog((Task)this));
                merger.merge(parsedMergeWebXml);
            }
            catch (IOException e) {
                throw new BuildException("Could not merge deployment descriptors", (Throwable)e);
            }
            catch (SAXException e) {
                throw new BuildException("Parsing of merge file failed", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("XML parser configuration error", (Throwable)e);
            }
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        File tmpWebXml = fileUtils.createTempFile("cactus", "web.xml", this.getProject().getBaseDir());
        tmpWebXml.deleteOnExit();
        try {
            WebXmlIo.writeWebXml(theWebXml, tmpWebXml);
        }
        catch (IOException ioe) {
            throw new BuildException("Could not write temporary deployment descriptor", (Throwable)ioe);
        }
        return tmpWebXml;
    }

    private WebXml getOriginalWebXml() throws BuildException {
        WarArchive war = null;
        try {
            war = new WarArchive(this.srcFile);
            WebXml webXml = war.getWebXml();
            if (webXml == null) {
                throw new BuildException("The source file does not contain a deployment descriptor");
            }
            return webXml;
        }
        catch (SAXException e) {
            throw new BuildException("Parsing of deployment descriptor failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Failed to open WAR", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("XML parser configuration error", (Throwable)e);
        }
    }

    private WebXml getPrototypeWebXml(WebXml theWebXml) throws BuildException {
        try {
            WebXml webXml = WebXmlIo.newWebXml(theWebXml.getVersion());
            webXml.addFilter("FilterRedirector", FILTER_REDIRECTOR_CLASS);
            if (this.filterRedirector != null) {
                webXml.addFilterMapping("FilterRedirector", this.filterRedirector.getMapping());
            } else {
                webXml.addFilterMapping("FilterRedirector", DEFAULT_FILTER_REDIRECTOR_MAPPING);
            }
            webXml.addJspFile("JspRedirector", "/jspRedirector.jsp");
            if (this.jspRedirector != null) {
                webXml.addServletMapping("JspRedirector", this.jspRedirector.getMapping());
            } else {
                webXml.addServletMapping("JspRedirector", DEFAULT_JSP_REDIRECTOR_MAPPING);
            }
            webXml.addServlet("ServletRedirector", SERVLET_REDIRECTOR_CLASS);
            if (this.servletRedirector != null) {
                webXml.addServletMapping("ServletRedirector", this.servletRedirector.getMapping());
            } else {
                webXml.addServletMapping("ServletRedirector", DEFAULT_SERVLET_REDIRECTOR_MAPPING);
            }
            return webXml;
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Could not parse deployment descriptor", (Throwable)e);
        }
    }

    public static class Version
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"2.2", "2.3"};
        }
    }

    public static class Redirector {
        private String mapping;

        public String getMapping() {
            return this.mapping;
        }

        public void setMapping(String theMapping) {
            this.mapping = theMapping;
        }
    }
}

