/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.ContainerSet;
import org.apache.cactus.integration.ant.container.Container;
import org.apache.cactus.integration.ant.container.ContainerRunner;
import org.apache.cactus.integration.ant.deployment.ApplicationXml;
import org.apache.cactus.integration.ant.deployment.EarArchive;
import org.apache.cactus.integration.ant.deployment.WarArchive;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.AntTaskFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Environment;
import org.xml.sax.SAXException;

public class CactusTask
extends JUnitTask {
    private ContainerSet containerSet;
    private File earFile;
    private File warFile;
    private transient AntTaskFactory antTaskFactory = new AntTaskFactory(){

        public Task createTask(String theName) {
            Task retVal = CactusTask.this.getProject().createTask(theName);
            if (retVal != null) {
                retVal.setTaskName(CactusTask.this.getTaskName());
                retVal.setLocation(CactusTask.this.getLocation());
                retVal.setOwningTarget(CactusTask.this.getOwningTarget());
            }
            return retVal;
        }
    };

    public void init() {
        super.init();
        this.addClasspathEntry("/org/aspectj/lang/JoinPoint.class");
        this.addClasspathEntry("/org/apache/cactus/ServletTestCase.class");
        this.addClasspathEntry("/org/apache/cactus/integration/ant/CactusTask.class");
        this.addClasspathEntry("/org/apache/commons/logging/Log.class");
        this.addClasspathEntry("/org/apache/commons/httpclient/HttpClient.class");
    }

    public void execute() throws BuildException {
        if (this.warFile == null && this.earFile == null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute");
        }
        WarArchive war = null;
        String contextPath = null;
        try {
            if (this.warFile != null) {
                war = new WarArchive(this.warFile);
                contextPath = this.warFile.getName();
                int warIndex = contextPath.toLowerCase().lastIndexOf(".war");
                if (warIndex >= 0) {
                    contextPath = contextPath.substring(0, warIndex);
                }
            } else {
                EarArchive ear = new EarArchive(this.earFile);
                String webUri = this.getUriOfCactifiedWebModule(ear);
                if (webUri == null) {
                    throw new BuildException("Could not find cactified web module in the EAR");
                }
                war = ear.getWebModule(webUri);
                if (war == null) {
                    throw new BuildException("Could not find the WAR " + webUri + " in the EAR");
                }
                contextPath = ear.getApplicationXml().getWebModuleContextRoot(webUri);
            }
            this.addRedirectorNameProperties(war);
        }
        catch (SAXException e) {
            throw new BuildException("Parsing of deployment descriptor failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Failed to open WAR", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("XML parser configuration error", (Throwable)e);
        }
        if (this.containerSet == null) {
            this.log("No containers specified, tests will run locally", 3);
            super.execute();
        } else {
            Container[] containers = this.containerSet.getContainers();
            Environment.Variable contextUrl = new Environment.Variable();
            contextUrl.setKey("cactus.contextURL");
            this.addSysproperty(contextUrl);
            for (int i = 0; i < containers.length; ++i) {
                containers[i].setAntTaskFactory(this.antTaskFactory);
                containers[i].setLog(new AntLog((Task)this));
                containers[i].setDeployableFile(this.earFile != null ? this.earFile : this.warFile);
                if (!containers[i].isEnabled()) continue;
                containers[i].init();
                this.log("-----------------------------------------------------------------", 2);
                this.log("Running tests against " + containers[i].getName(), 2);
                this.log("-----------------------------------------------------------------", 2);
                contextUrl.setValue("http://localhost:" + containers[i].getPort() + "/" + contextPath);
                this.executeInContainer(containers[i], war, contextPath);
            }
        }
    }

    public final void addContainerSet(ContainerSet theContainerSet) {
        if (this.containerSet != null) {
            throw new BuildException("Only one nested containerset element supported");
        }
        this.containerSet = theContainerSet;
    }

    public final void setEarFile(File theEarFile) {
        if (this.warFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.earFile = theEarFile;
    }

    public final void setWarFile(File theWarFile) {
        if (this.earFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.warFile = theWarFile;
    }

    private void addCactusProperty(String theKey, String theValue) {
        this.log("Adding Cactus system property 'cactus." + theKey + "' with value '" + theValue + "'", 3);
        Environment.Variable sysProperty = new Environment.Variable();
        sysProperty.setKey("cactus." + theKey);
        sysProperty.setValue(theValue);
        this.addSysproperty(sysProperty);
    }

    private void addRedirectorNameProperties(WarArchive theWar) throws SAXException, IOException, ParserConfigurationException {
        String filterRedirectorMapping = this.getFilterRedirectorMapping(theWar);
        if (filterRedirectorMapping != null) {
            this.addCactusProperty("filterRedirectorName", filterRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the filter redirector found", 3);
        }
        String jspRedirectorMapping = this.getJspRedirectorMapping(theWar);
        if (jspRedirectorMapping != null) {
            this.addCactusProperty("jspRedirectorName", jspRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the JSP redirector found", 3);
        }
        String servletRedirectorMapping = this.getServletRedirectorMapping(theWar);
        if (servletRedirectorMapping == null) {
            throw new BuildException("The WAR has not been cactified");
        }
        this.addCactusProperty("servletRedirectorName", servletRedirectorMapping.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInContainer(Container theContainer, WarArchive theWar, String theContextPath) {
        this.log("Starting up container", 3);
        ContainerRunner runner = new ContainerRunner(theContainer);
        runner.setLog(new AntLog((Task)this));
        try {
            URL url = new URL("http", "localhost", theContainer.getPort(), "/" + theContextPath + this.getServletRedirectorMapping(theWar) + "?Cactus_Service=RUN_TEST");
            runner.setUrl(url);
            if (this.containerSet.getTimeout() > 0L) {
                runner.setTimeout(this.containerSet.getTimeout());
            }
            runner.startUpContainer();
            this.log("Container responding to HTTP requests as " + runner.getServerName(), 3);
            try {
                Enumeration tests = this.getIndividualTests();
                while (tests.hasMoreElements()) {
                    JUnitTest test = (JUnitTest)tests.nextElement();
                    if (!test.shouldRun(this.getProject()) || theContainer.isExcluded(test.getName())) continue;
                    if (theContainer.getToDir() != null) {
                        test.setTodir(theContainer.getToDir());
                    }
                    this.execute(test);
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.log("Shutting down container", 3);
                runner.shutDownContainer();
                this.log("Container shut down", 3);
                throw throwable;
            }
            this.log("Shutting down container", 3);
            runner.shutDownContainer();
            this.log("Container shut down", 3);
            {
            }
        }
        catch (MalformedURLException mue) {
            throw new BuildException("Malformed test URL", (Throwable)mue);
        }
        catch (SAXException saxe) {
            throw new BuildException("Error parsing a deployment descriptor", (Throwable)saxe);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new BuildException((Throwable)pce);
        }
    }

    private String getFilterRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException {
        Iterator filterNames = theWar.getWebXml().getFilterNamesForClass("org.apache.cactus.server.FilterTestRedirector");
        if (filterNames.hasNext()) {
            String name = (String)filterNames.next();
            Iterator mappings = theWar.getWebXml().getFilterMappings(name);
            if (mappings.hasNext()) {
                return (String)mappings.next();
            }
        }
        return null;
    }

    private String getJspRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException {
        String jspRedirectorPath = theWar.findResource("jspRedirector.jsp");
        if (jspRedirectorPath != null) {
            jspRedirectorPath = "/" + jspRedirectorPath;
            Iterator jspNames = theWar.getWebXml().getServletNamesForJspFile(jspRedirectorPath);
            if (jspNames.hasNext()) {
                String name = (String)jspNames.next();
                Iterator mappings = theWar.getWebXml().getServletMappings(name);
                if (mappings.hasNext()) {
                    return (String)mappings.next();
                }
            }
        }
        return null;
    }

    private String getServletRedirectorMapping(WarArchive theWar) throws SAXException, IOException, ParserConfigurationException {
        Iterator servletNames = theWar.getWebXml().getServletNamesForClass("org.apache.cactus.server.ServletTestRedirector");
        if (servletNames.hasNext()) {
            String name = (String)servletNames.next();
            Iterator mappings = theWar.getWebXml().getServletMappings(name);
            if (mappings.hasNext()) {
                return (String)mappings.next();
            }
        }
        return null;
    }

    private String getUriOfCactifiedWebModule(EarArchive theEar) {
        try {
            ApplicationXml applicationXml = theEar.getApplicationXml();
            Iterator i = applicationXml.getWebModuleUris();
            while (i.hasNext()) {
                String webUri = (String)i.next();
                WarArchive war = theEar.getWebModule(webUri);
                if (war == null || this.getServletRedirectorMapping(war) == null) continue;
                return webUri;
            }
        }
        catch (SAXException e) {
            throw new BuildException("Parsing of deployment descriptor failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Failed to open WAR", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("XML parser configuration error", (Throwable)e);
        }
        return null;
    }
}

