/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cactus.integration.ant.container.AbstractContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.CallTarget;

public class GenericContainer
extends AbstractContainer {
    private String name = "Unknown Container";
    private Hook startUpHook;
    private Hook shutDownHook;
    private int port = 8080;

    public final Hook createStartUp() throws BuildException {
        if (this.isStartUpSet()) {
            throw new BuildException("The container element supports only onenested [startup] element");
        }
        this.startUpHook = new Hook();
        return this.startUpHook;
    }

    public final Hook createShutDown() throws BuildException {
        if (this.isShutDownSet()) {
            throw new BuildException("The container element supports only onenested [shutdown] element");
        }
        this.shutDownHook = new Hook();
        return this.shutDownHook;
    }

    public boolean isShutDownSet() {
        return this.shutDownHook != null;
    }

    public boolean isStartUpSet() {
        return this.startUpHook != null;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public void setStartUpTarget(String theStartUpTarget) {
        if (this.isStartUpSet()) {
            throw new BuildException("Either specify the [startuptarget] attribute or the nested [startup] element, but not both");
        }
        this.startUpHook = new Hook();
        this.startUpHook.setTarget(theStartUpTarget);
    }

    public void setShutDownTarget(String theShutDownTarget) {
        if (this.isShutDownSet()) {
            throw new BuildException("Either specify the [shutdowntarget] attribute or the nested [shutdown] element, but not both");
        }
        this.shutDownHook = new Hook();
        this.shutDownHook.setTarget(theShutDownTarget);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPort() {
        return this.port;
    }

    public final void startUp() throws BuildException {
        if (this.startUpHook != null) {
            this.startUpHook.execute();
        }
    }

    public final void shutDown() throws BuildException {
        if (this.shutDownHook != null) {
            this.shutDownHook.execute();
        }
    }

    public class Hook
    implements TaskContainer {
        private String target;
        private List tasks = new ArrayList();

        public void setTarget(String theTarget) {
            if (!this.tasks.isEmpty()) {
                throw new BuildException("The generic element supports either a [target] attribute or nested tasks, but not both");
            }
            this.target = theTarget;
        }

        public void addTask(Task theTask) throws BuildException {
            if (this.target != null) {
                throw new BuildException("The generic element supports either a [target] attribute or nested tasks, but not both");
            }
            this.tasks.add(theTask);
        }

        public void execute() throws BuildException {
            if (this.target != null) {
                CallTarget antCall = (CallTarget)GenericContainer.this.createAntTask("antcall");
                antCall.setInheritAll(true);
                antCall.setInheritRefs(true);
                antCall.init();
                antCall.setTarget(this.target);
                antCall.execute();
            } else {
                Iterator i = this.tasks.iterator();
                while (i.hasNext()) {
                    Task task = (Task)i.next();
                    task.perform();
                }
            }
        }
    }
}

