/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.util;

import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntLog
implements Log {
    public static final Log NULL = new Log(){

        public boolean isFatalEnabled() {
            return false;
        }

        public void fatal(Object theMessage) {
        }

        public void fatal(Object theMessage, Throwable theThrowable) {
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public void error(Object theMessage) {
        }

        public void error(Object theMessage, Throwable theThrowable) {
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void warn(Object theMessage) {
        }

        public void warn(Object theMessage, Throwable theThrowable) {
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public void info(Object theMessage) {
        }

        public void info(Object theMessage, Throwable theThrowable) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(Object theMessage) {
        }

        public void debug(Object theMessage, Throwable theThrowable) {
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void trace(Object theMessage) {
        }

        public void trace(Object theMessage, Throwable theThrowable) {
        }
    };
    private Project project;
    private Target target;
    private Task task;

    public AntLog(Task theTask) {
        this.project = theTask.getProject();
        this.task = theTask;
    }

    public AntLog(Target theTarget) {
        this.project = theTarget.getProject();
        this.target = theTarget;
    }

    public AntLog(Project theProject) {
        this.project = theProject;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void fatal(Object theMessage) {
        this.log(theMessage, null, 0);
    }

    public void fatal(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 0);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(Object theMessage) {
        this.log(theMessage, null, 0);
    }

    public void error(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 0);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(Object theMessage) {
        this.log(theMessage, null, 1);
    }

    public void warn(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 1);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(Object theMessage) {
        this.log(theMessage, null, 2);
    }

    public void info(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 2);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(Object theMessage) {
        this.log(theMessage, null, 4);
    }

    public void debug(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 4);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(Object theMessage) {
        this.log(theMessage, null, 3);
    }

    public void trace(Object theMessage, Throwable theThrowable) {
        this.log(theMessage, theThrowable, 3);
    }

    private void log(Object theMessage, Throwable theThrowable, int theLogLevel) {
        String message = String.valueOf(theMessage);
        if (theThrowable != null) {
            message = message + " (" + theThrowable.getMessage() + ")";
        }
        if (this.task != null) {
            this.project.log(this.task, message, theLogLevel);
        } else if (this.target != null) {
            this.project.log(this.target, message, theLogLevel);
        } else {
            this.project.log(message, theLogLevel);
        }
    }
}

