/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cactus.integration.ant.ContainerSet;
import org.apache.cactus.integration.ant.container.AbstractDeployableFile;
import org.apache.cactus.integration.ant.container.Container;
import org.apache.cactus.integration.ant.container.ContainerRunner;
import org.apache.cactus.integration.ant.container.DeployableFile;
import org.apache.cactus.integration.ant.container.EarParser;
import org.apache.cactus.integration.ant.container.WarParser;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.cactus.integration.ant.util.AntTaskFactory;
import org.apache.cactus.integration.ant.util.PropertySet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class CactusTask
extends JUnitTask {
    private ContainerSet containerSet;
    private File earFile;
    private File warFile;
    private List systemProperties = new ArrayList();
    private Path containerClasspath;
    private AntTaskFactory antTaskFactory = new AntTaskFactory(){

        public Task createTask(String theName) {
            Task retVal = CactusTask.this.getProject().createTask(theName);
            if (retVal != null) {
                retVal.setTaskName(CactusTask.this.getTaskName());
                retVal.setLocation(CactusTask.this.getLocation());
                retVal.setOwningTarget(CactusTask.this.getOwningTarget());
            }
            return retVal;
        }
    };

    public void init() {
        super.init();
        this.addClasspathEntry("/org/aspectj/lang/JoinPoint.class");
        this.addClasspathEntry("/org/apache/cactus/ServletTestCase.class");
        this.addClasspathEntry("/org/apache/cactus/integration/ant/CactusTask.class");
        this.addClasspathEntry("/org/apache/commons/logging/Log.class");
        this.addClasspathEntry("/org/apache/commons/httpclient/HttpClient.class");
    }

    public void execute() throws BuildException {
        if (this.warFile == null && this.earFile == null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute");
        }
        if (this.warFile != null && this.earFile != null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute but not both");
        }
        AbstractDeployableFile deployableFile = this.warFile != null ? WarParser.parse(this.warFile) : EarParser.parse(this.earFile);
        this.addRedirectorNameProperties(deployableFile);
        if (this.containerSet == null) {
            this.log("No containers specified, tests will run locally", 3);
            super.execute();
        } else {
            Container[] containers = this.containerSet.getContainers();
            Environment.Variable contextUrl = new Environment.Variable();
            contextUrl.setKey("cactus.contextURL");
            this.addSysproperty(contextUrl);
            for (int i = 0; i < containers.length; ++i) {
                containers[i].setAntTaskFactory(this.antTaskFactory);
                containers[i].setLog(new AntLog((Task)this));
                DeployableFile thisDeployable = null;
                try {
                    thisDeployable = (DeployableFile)deployableFile.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new BuildException((Throwable)e);
                }
                containers[i].setDeployableFile(thisDeployable);
                if (containers[i].getTestContext() != null) {
                    thisDeployable.setTestContext(containers[i].getTestContext());
                }
                containers[i].setSystemProperties(this.systemProperties.toArray(new Environment.Variable[0]));
                containers[i].setContainerClasspath(this.containerClasspath);
                if (!containers[i].isEnabled()) continue;
                containers[i].init();
                this.log("-----------------------------------------------------------------", 2);
                this.log("Running tests against " + containers[i].getName(), 2);
                this.log("-----------------------------------------------------------------", 2);
                contextUrl.setValue("http://localhost:" + containers[i].getPort() + "/" + thisDeployable.getTestContext());
                this.executeInContainer(containers[i], thisDeployable);
            }
        }
    }

    public final void addContainerSet(ContainerSet theContainerSet) {
        if (this.containerSet != null) {
            throw new BuildException("Only one nested containerset element supported");
        }
        this.containerSet = theContainerSet;
    }

    public final void setEarFile(File theEarFile) {
        if (this.warFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.earFile = theEarFile;
    }

    public final void setWarFile(File theWarFile) {
        if (this.earFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.warFile = theWarFile;
    }

    public void addSysproperty(Environment.Variable theProperty) {
        this.addCactusServerProperty(theProperty);
        super.addSysproperty(theProperty);
    }

    public void addConfiguredSysproperty(Environment.Variable theProperty) {
        this.addSysproperty(theProperty);
    }

    public void addConfiguredCactusproperty(PropertySet thePropertySet) {
        ResourceBundle bundle = thePropertySet.readProperties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            if (thePropertySet.isServer()) {
                this.addCactusServerProperty(var);
                continue;
            }
            super.addSysproperty(var);
        }
    }

    public Path createContainerClasspath() {
        if (this.containerClasspath == null) {
            this.containerClasspath = new Path(this.project);
        }
        return this.containerClasspath.createPath();
    }

    private void addCactusClientProperty(String theKey, String theValue) {
        this.log("Adding Cactus client system property [" + theKey + "] with value [" + theValue + "]", 3);
        Environment.Variable sysProperty = new Environment.Variable();
        sysProperty.setKey(theKey);
        sysProperty.setValue(theValue);
        super.addSysproperty(sysProperty);
    }

    private void addCactusServerProperty(Environment.Variable theProperty) {
        this.log("Adding Cactus server system property [" + theProperty.getKey() + "] with value [" + theProperty.getValue() + "]", 3);
        this.systemProperties.add(theProperty);
    }

    private void addCactusServerProperty(String theKey, String theValue) {
        Environment.Variable property = new Environment.Variable();
        property.setKey(theKey);
        property.setValue(theValue);
        this.addCactusServerProperty(property);
    }

    private void addRedirectorNameProperties(DeployableFile theFile) {
        String filterRedirectorMapping = theFile.getFilterRedirectorMapping();
        if (filterRedirectorMapping != null) {
            this.addCactusClientProperty("cactus.filterRedirectorName", filterRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the filter redirector found", 3);
        }
        String jspRedirectorMapping = theFile.getJspRedirectorMapping();
        if (jspRedirectorMapping != null) {
            this.addCactusClientProperty("cactus.jspRedirectorName", jspRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the JSP redirector found", 3);
        }
        String servletRedirectorMapping = theFile.getServletRedirectorMapping();
        if (servletRedirectorMapping == null) {
            throw new BuildException("The WAR has not been cactified");
        }
        this.addCactusClientProperty("cactus.servletRedirectorName", servletRedirectorMapping.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInContainer(Container theContainer, DeployableFile theFile) {
        this.log("Starting up container", 3);
        ContainerRunner runner = new ContainerRunner(theContainer);
        runner.setLog(new AntLog((Task)this));
        try {
            URL url = new URL("http", "localhost", theContainer.getPort(), "/" + theFile.getTestContext() + theFile.getServletRedirectorMapping() + "?Cactus_Service=RUN_TEST");
            runner.setUrl(url);
            if (this.containerSet.getTimeout() > 0L) {
                runner.setTimeout(this.containerSet.getTimeout());
            }
            runner.startUpContainer();
            this.log("Container responding to HTTP requests as " + runner.getServerName(), 3);
            try {
                Enumeration tests = this.getIndividualTests();
                while (tests.hasMoreElements()) {
                    JUnitTest test = (JUnitTest)tests.nextElement();
                    if (!test.shouldRun(this.getProject()) || theContainer.isExcluded(test.getName())) continue;
                    if (theContainer.getToDir() != null) {
                        test.setTodir(theContainer.getToDir());
                    }
                    this.execute(test);
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.log("Shutting down container", 3);
                runner.shutDownContainer();
                this.log("Container shut down", 3);
                throw throwable;
            }
            this.log("Shutting down container", 3);
            runner.shutDownContainer();
            this.log("Container shut down", 3);
            {
            }
        }
        catch (MalformedURLException mue) {
            throw new BuildException("Malformed test URL", (Throwable)mue);
        }
    }
}

