/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment;

import java.util.Iterator;
import org.apache.cactus.integration.ant.deployment.WebXml;
import org.apache.cactus.integration.ant.deployment.WebXmlTag;
import org.apache.cactus.integration.ant.deployment.WebXmlVersion;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class WebXmlMerger {
    private WebXml webXml;
    private Log log = AntLog.NULL;

    public WebXmlMerger(WebXml theWebXml) {
        this.webXml = theWebXml;
    }

    public final void merge(WebXml theMergeWebXml) {
        this.checkServletVersions(theMergeWebXml);
        this.mergeContextParams(theMergeWebXml);
        if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
            this.mergeFilters(theMergeWebXml);
        }
        this.mergeServlets(theMergeWebXml);
        if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
            this.mergeResourceEnvironmentReferences(theMergeWebXml);
        }
        this.mergeResourceReferences(theMergeWebXml);
        this.mergeSecurityConstraints(theMergeWebXml);
        this.mergeLoginConfig(theMergeWebXml);
        this.mergeSecurityRoles(theMergeWebXml);
        this.mergeEnvironmentEntries(theMergeWebXml);
        this.mergeEjbRefs(theMergeWebXml);
        if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
            this.mergeEjbLocalRefs(theMergeWebXml);
        }
    }

    public final void setLog(Log theLog) {
        this.log = theLog;
    }

    protected final void checkServletVersions(WebXml theWebXml) {
        if (this.webXml.getVersion() != null && this.webXml.getVersion().compareTo(theWebXml.getVersion()) < 0) {
            this.log.warn((Object)("Merging elements from a version " + theWebXml.getVersion() + " descriptor into a version " + this.webXml.getVersion() + ", some elements may be skipped"));
        }
    }

    protected final void mergeContextParams(WebXml theWebXml) {
        Iterator contextParams = theWebXml.getElements(WebXmlTag.CONTEXT_PARAM);
        int count = 0;
        while (contextParams.hasNext()) {
            String paramName = theWebXml.getContextParamName((Element)contextParams.next());
            if (!this.webXml.hasContextParam(paramName)) {
                this.webXml.addContextParam(theWebXml.getContextParam(paramName));
            }
            ++count;
        }
        this.log.trace((Object)("Merged " + count + " context-param definition" + (count != 1 ? "s " : " ") + "into the descriptor"));
    }

    protected final void mergeFilters(WebXml theWebXml) {
        Iterator filterNames = theWebXml.getFilterNames();
        int count = 0;
        while (filterNames.hasNext()) {
            String filterName = (String)filterNames.next();
            if (!this.webXml.hasFilter(filterName)) {
                this.webXml.addFilter(theWebXml.getFilter(filterName));
            } else {
                Iterator filterInitParamNames = theWebXml.getFilterInitParamNames(filterName);
                while (filterInitParamNames.hasNext()) {
                    String paramName = (String)filterInitParamNames.next();
                    String paramValue = theWebXml.getFilterInitParam(filterName, paramName);
                    this.webXml.addFilterInitParam(filterName, paramName, paramValue);
                }
            }
            Iterator filterMappings = theWebXml.getFilterMappings(filterName);
            while (filterMappings.hasNext()) {
                String urlPattern = (String)filterMappings.next();
                this.webXml.addFilterMapping(filterName, urlPattern);
            }
            ++count;
        }
        this.log.trace((Object)("Merged " + count + " filter definition" + (count != 1 ? "s " : " ") + "into the descriptor"));
    }

    protected final void mergeServlets(WebXml theWebXml) {
        Iterator servletNames = theWebXml.getServletNames();
        int count = 0;
        while (servletNames.hasNext()) {
            String servletName = (String)servletNames.next();
            if (!this.webXml.hasServlet(servletName)) {
                this.webXml.addServlet(theWebXml.getServlet(servletName));
            } else {
                Iterator servletInitParamNames = theWebXml.getServletInitParamNames(servletName);
                while (servletInitParamNames.hasNext()) {
                    String paramName = (String)servletInitParamNames.next();
                    String paramValue = theWebXml.getServletInitParam(servletName, paramName);
                    this.webXml.addServletInitParam(servletName, paramName, paramValue);
                }
            }
            Iterator servletMappings = theWebXml.getServletMappings(servletName);
            while (servletMappings.hasNext()) {
                String urlPattern = (String)servletMappings.next();
                this.webXml.addServletMapping(servletName, urlPattern);
            }
            ++count;
        }
        this.log.trace((Object)("Merged " + count + " servlet definition" + (count != 1 ? "s " : " ") + "into the descriptor"));
    }

    protected final void mergeResourceEnvironmentReferences(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.RESOURCE_ENV_REF);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " resource environment " + "reference" + (count != 1 ? "s " : " ") + "into the " + "descriptor"));
        }
    }

    protected final void mergeResourceReferences(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.RESOURCE_REF);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " resource reference" + (count != 1 ? "s " : " ") + "into the descriptor"));
        }
    }

    protected final void mergeSecurityConstraints(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.SECURITY_CONSTRAINT);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " security constraint" + (count != 1 ? "s " : " ") + "into the descriptor"));
        }
    }

    protected final void mergeLoginConfig(WebXml theWebXml) {
        boolean replaced = this.replaceElement(theWebXml, WebXmlTag.LOGIN_CONFIG);
        if (replaced) {
            this.log.trace((Object)"Merged the login configuration into the descriptor");
        }
    }

    protected final void mergeSecurityRoles(WebXml theWebXml) {
        Iterator securityRoleNames = theWebXml.getSecurityRoleNames();
        int count = 0;
        while (securityRoleNames.hasNext()) {
            String securityRoleName = (String)securityRoleNames.next();
            if (this.webXml.hasSecurityRole(securityRoleName)) continue;
            this.webXml.addSecurityRole(securityRoleName);
        }
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " security role" + (count != 1 ? "s " : " ") + "into the descriptor"));
        }
    }

    protected final void mergeEnvironmentEntries(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.ENV_ENTRY);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " environment entr" + (count != 1 ? "ies " : "y ") + "into the descriptor"));
        }
    }

    protected final void mergeEjbRefs(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.EJB_REF);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " EJB reference" + (count != 1 ? "s " : "y ") + "into the descriptor"));
        }
    }

    protected final void mergeEjbLocalRefs(WebXml theWebXml) {
        int count = this.insertElements(theWebXml, WebXmlTag.EJB_LOCAL_REF);
        if (count > 0) {
            this.log.trace((Object)("Merged " + count + " EJB local reference" + (count != 1 ? "s " : "y ") + "into the descriptor"));
        }
    }

    private int insertElements(WebXml theWebXml, WebXmlTag theTag) {
        Iterator elements = theWebXml.getElements(theTag);
        int count = 0;
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            this.webXml.addElement(theTag, element);
            ++count;
        }
        return count;
    }

    private boolean replaceElement(WebXml theWebXml, WebXmlTag theTag) {
        Iterator elements = theWebXml.getElements(theTag);
        if (elements.hasNext()) {
            this.webXml.replaceElement(theTag, (Element)elements.next());
            return true;
        }
        return false;
    }
}

