/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.orion;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractOrionContainer
extends AbstractJavaContainer {
    private File dir;
    private int port = 8080;
    private File tmpDir;

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final int getPort() {
        return this.port;
    }

    public final void init() {
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir + " is not a directory");
        }
    }

    public final void shutDown() {
        Java java = this.createJavaForShutDown();
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.dir);
        fileSet.createInclude().setName("*.jar");
        classpath.addFileset(fileSet);
        java.setClassname("com.evermind.client.orion.OrionConsoleAdmin");
        java.createArg().setValue("ormi://localhost:23791/");
        java.createArg().setValue("admin");
        java.createArg().setValue("password");
        java.createArg().setValue("-shutdown");
        java.execute();
    }

    protected final void invokeServer() {
        Java java = this.createJavaForStartUp();
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.dir);
        fileSet.createInclude().setName("*.jar");
        classpath.addFileset(fileSet);
        this.addToolsJarToClasspath(classpath);
        java.setClassname("com.evermind.server.ApplicationServer");
        java.createArg().setValue("-config");
        java.createArg().setFile(new File(this.tmpDir, "conf/server.xml"));
        java.execute();
    }

    protected final void prepare(String theResourcePrefix, String theDirName) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createFilterChain();
        if (this.tmpDir == null) {
            this.tmpDir = this.createTempDirectory(theDirName);
        }
        File confDir = this.createDirectory(this.tmpDir, "conf");
        String sharePath = "/org/apache/cactus/integration/ant/container/resources/" + theResourcePrefix + "/share";
        String specificPath = this.getDeployableFile().isWar() ? "/org/apache/cactus/integration/ant/container/resources/" + theResourcePrefix + "/war" : "/org/apache/cactus/integration/ant/container/resources/" + theResourcePrefix + "/ear";
        ResourceUtils.copyResource(this.getProject(), specificPath + "/server.xml", new File(confDir, "server.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), specificPath + "/application.xml", new File(confDir, "application.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), specificPath + "/default-web-site.xml", new File(confDir, "default-web-site.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), sharePath + "/global-web-application.xml", new File(confDir, "global-web-application.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), sharePath + "/mime.types", new File(confDir, "mime.types"), filterChain);
        ResourceUtils.copyResource(this.getProject(), sharePath + "/principals.xml", new File(confDir, "principals.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), sharePath + "/rmi.xml", new File(confDir, "rmi.xml"), filterChain);
        File defaultWebAppDir = this.createDirectory(this.tmpDir, "default-web-app/WEB-INF");
        ResourceUtils.copyResource(this.getProject(), sharePath + "/web.xml", new File(defaultWebAppDir, "web.xml"), filterChain);
        this.createDirectory(this.tmpDir, "persistence");
        File appDir = this.createDirectory(this.tmpDir, "applications");
        this.createDirectory(this.tmpDir, "application-deployments");
        this.createDirectory(this.tmpDir, "log");
        fileUtils.copyFile(this.getDeployableFile().getFile(), new File(appDir, this.getDeployableFile().getFile().getName()), null, true);
    }
}

