/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.cactus.integration.ant.CactifyWarTask;
import org.apache.cactus.integration.api.version.Version;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Ear;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.ApplicationXmlIo;
import org.codehaus.cargo.module.application.DefaultEarArchive;
import org.codehaus.cargo.module.ejb.EjbArchive;
import org.codehaus.cargo.module.ejb.EjbJarXml;
import org.codehaus.cargo.module.ejb.Entity;
import org.codehaus.cargo.module.ejb.Session;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.jdom.JDOMException;

public class CactifyEarTask
extends Ear {
    private CactifyWarTask cactusWar;
    private File srcFile;
    private boolean addEjbReferences;

    public void addConfiguredCactuswar(CactifyWarTask theCactusWar) {
        this.cactusWar = theCactusWar;
    }

    public void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public boolean getAddEjbReferences() {
        return this.addEjbReferences;
    }

    public void setAddEjbReferences(boolean isAddEjbReferences) {
        this.addEjbReferences = isAddEjbReferences;
    }

    public void execute() throws BuildException {
        if (this.cactusWar == null) {
            this.cactusWar = this.createCactusWarConfig();
        }
        ZipFileSet currentFiles = new ZipFileSet();
        currentFiles.setSrc(this.srcFile);
        currentFiles.createExclude().setName("META-INF/application.xml");
        this.addZipfileset(currentFiles);
        ApplicationXml appXml = null;
        try {
            appXml = this.getOriginalApplicationXml();
        }
        catch (JDOMException e) {
            throw new BuildException("Unable to get the original application.xml", (Throwable)e);
        }
        File tmpAppXml = this.cactifyApplicationXml(appXml);
        this.setAppxml(tmpAppXml);
        File cactusWarFile = this.createCactusWar();
        this.addFileToEar(cactusWarFile, this.cactusWar.getFileName());
        super.execute();
    }

    private ApplicationXml getOriginalApplicationXml() throws JDOMException {
        ApplicationXml appXml = null;
        try {
            DefaultEarArchive ear = new DefaultEarArchive((InputStream)new FileInputStream(this.srcFile));
            appXml = ear.getApplicationXml();
            if (appXml == null) {
                throw new BuildException("The EAR source file does not contain a META-INF/application.xml deployment descriptor");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to open EAR", (Throwable)e);
        }
        return appXml;
    }

    private File cactifyApplicationXml(ApplicationXml theAppXml) {
        theAppXml.addWebModule(this.cactusWar.getFileName(), this.cactusWar.getContext());
        FileUtils fileUtils = FileUtils.newFileUtils();
        File tmpAppXml = fileUtils.createTempFile("cactus", "application.xml", this.getProject().getBaseDir());
        tmpAppXml.deleteOnExit();
        try {
            ApplicationXmlIo.writeApplicationXml((ApplicationXml)theAppXml, (File)tmpAppXml, null, (boolean)true);
        }
        catch (IOException ioe) {
            throw new BuildException("Could not write temporary deployment descriptor", (Throwable)ioe);
        }
        return tmpAppXml;
    }

    private File createCactusWar() {
        FileUtils fileUtils = FileUtils.newFileUtils();
        File tmpCactusWar = fileUtils.createTempFile("cactus", "cactus.war", this.getProject().getBaseDir());
        tmpCactusWar.deleteOnExit();
        this.cactusWar.setDestFile(tmpCactusWar);
        if (this.addEjbReferences) {
            try {
                this.addEjbReferencesToWar(tmpCactusWar);
            }
            catch (JDOMException e) {
                throw new BuildException("Unable to add ejb-references", (Throwable)e);
            }
        }
        this.cactusWar.execute();
        return tmpCactusWar;
    }

    private void addFileToEar(File theFile, String theFullPath) {
        ZipFileSet fs = new ZipFileSet();
        fs.setFile(theFile);
        fs.setFullpath(theFullPath);
        this.addZipfileset(fs);
    }

    private CactifyWarTask createCactusWarConfig() {
        CactifyWarTask cactusWarConfig = new CactifyWarTask();
        Version version = new Version();
        version.setValue("2.3");
        cactusWarConfig.setVersion(version);
        cactusWarConfig.setContext("/cactus");
        cactusWarConfig.setProject(this.getProject());
        return cactusWarConfig;
    }

    private void addEjbReferencesToWar(File theWar) throws JDOMException {
        try {
            DefaultEarArchive ear = new DefaultEarArchive((InputStream)new FileInputStream(this.srcFile));
            ApplicationXml appXml = ear.getApplicationXml();
            Iterator ejbModules = appXml.getEjbModules();
            while (ejbModules.hasNext()) {
                EjbRef ref;
                String localHome;
                String local;
                String name;
                Session ejb;
                String module = (String)ejbModules.next();
                EjbArchive ejbArchive = ear.getEjbModule(module);
                EjbJarXml descr = ejbArchive.getEjbJarXml();
                Iterator vendorDescrIterator = descr.getVendorDescriptors();
                if (vendorDescrIterator == null || !vendorDescrIterator.hasNext()) {
                    throw new BuildException("Failed to find vendor deployment descriptor for ejb jar " + module);
                }
                Iterator ejbs = descr.getSessionEjbs();
                while (ejbs.hasNext()) {
                    ejb = (Session)ejbs.next();
                    name = ejb.getName();
                    local = ejb.getLocal();
                    localHome = ejb.getLocalHome();
                    if (local == null) continue;
                    this.log("Adding ejb-ref for local session ejb " + ejb.getName(), 3);
                    ref = new EjbRef();
                    ref.setType("Session");
                    ref.setEjbName(name);
                    ref.setName("ejb/" + name);
                    ref.setEjbInterface(local);
                    ref.setEjbHomeInterface(localHome);
                    ref.setLocal(true);
                    this.cactusWar.addConfiguredEjbref(ref);
                }
                ejbs = descr.getEntityEjbs();
                while (ejbs.hasNext()) {
                    ejb = (Entity)ejbs.next();
                    name = ejb.getName();
                    local = ejb.getLocal();
                    localHome = ejb.getLocalHome();
                    if (local == null) continue;
                    this.log("Adding ejb-ref for local entity ejb " + ejb.getName(), 3);
                    ref = new EjbRef();
                    ref.setType("Entity");
                    ref.setEjbName(name);
                    ref.setName("ejb/" + name);
                    ref.setEjbInterface(local);
                    ref.setEjbHomeInterface(localHome);
                    ref.setLocal(true);
                    this.cactusWar.addConfiguredEjbref(ref);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("Could not merge deployment descriptors", (Throwable)e);
        }
    }
}

