/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.container;

import java.io.File;
import java.util.Map;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.util.log.Logger;

public class ContainerWrapper {
    private Container container;

    public ContainerWrapper() {
    }

    public ContainerWrapper(Container theContainer) {
        if (theContainer == null) {
            throw new NullPointerException("'theContainer' must not be null");
        }
        this.container = theContainer;
    }

    public String getName() {
        return this.container.getName();
    }

    public String getTestContext() {
        return ((InstalledLocalContainer)this.container).getConfiguration().getPropertyValue("testContext");
    }

    public long getStartUpWait() {
        return 0L;
    }

    public int getPort() {
        String port = ((InstalledLocalContainer)this.container).getConfiguration().getPropertyValue("cargo.servlet.port");
        if (port != null) {
            return Integer.parseInt(port);
        }
        return 8080;
    }

    public File getToDir() {
        File toDir;
        String location = ((InstalledLocalContainer)this.container).getConfiguration().getPropertyValue("cactus.toDir");
        if (location != null) {
            toDir = new File(location);
        } else {
            toDir = new File("./target/" + this.container.getId() + "/");
            toDir.mkdirs();
        }
        return toDir;
    }

    public void init() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isExcluded(String theTestName) {
        return false;
    }

    public void startUp() {
        ((InstalledLocalContainer)this.container).start();
    }

    public void shutDown() {
        ((InstalledLocalContainer)this.container).stop();
    }

    public void setSystemProperties(Map theProperties) {
        if (theProperties != null) {
            ((InstalledLocalContainer)this.container).setSystemProperties(theProperties);
        }
    }

    public void setContainerClasspath(String[] theClasspath) {
        if (theClasspath != null) {
            ((InstalledLocalContainer)this.container).setExtraClasspath(theClasspath);
        }
    }

    public String[] getContainerClasspath() {
        return ((InstalledLocalContainer)this.container).getExtraClasspath();
    }

    public String getServer() {
        return ((InstalledLocalContainer)this.container).getConfiguration().getPropertyValue("cargo.hostname");
    }

    public String getProtocol() {
        return ((InstalledLocalContainer)this.container).getConfiguration().getPropertyValue("cargo.protocol");
    }

    public String getBaseURL() {
        return this.getProtocol() + "://" + this.getServer() + ":" + this.getPort();
    }

    public void setLogger(Logger theLogger) {
        this.container.setLogger(theLogger);
    }

    public void setContainer(Container theContainer) {
        this.container = theContainer;
    }
}

