/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NsUri;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.Portability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StackNode<T> {
    final int group;
    @Local
    final String name;
    @Local
    final String popName;
    @NsUri
    final String ns;
    final T node;
    final boolean scoping;
    final boolean special;
    final boolean fosterParenting;
    private int refcount = 1;

    StackNode(int group, @NsUri String ns, @Local String name, T node, boolean scoping, boolean special, boolean fosterParenting, @Local String popName) {
        this.group = group;
        this.name = name;
        this.popName = popName;
        this.ns = ns;
        this.node = node;
        this.scoping = scoping;
        this.special = special;
        this.fosterParenting = fosterParenting;
        this.refcount = 1;
        Portability.retainLocal(name);
        Portability.retainLocal(popName);
        Portability.retainElement(node);
    }

    StackNode(@NsUri String ns, ElementName elementName, T node) {
        this.group = elementName.group;
        this.name = elementName.name;
        this.popName = elementName.name;
        this.ns = ns;
        this.node = node;
        this.scoping = elementName.scoping;
        this.special = elementName.special;
        this.fosterParenting = elementName.fosterParenting;
        this.refcount = 1;
        Portability.retainLocal(this.name);
        Portability.retainLocal(this.popName);
        Portability.retainElement(node);
    }

    StackNode(@NsUri String ns, ElementName elementName, T node, @Local String popName) {
        this.group = elementName.group;
        this.name = elementName.name;
        this.popName = popName;
        this.ns = ns;
        this.node = node;
        this.scoping = elementName.scoping;
        this.special = elementName.special;
        this.fosterParenting = elementName.fosterParenting;
        this.refcount = 1;
        Portability.retainLocal(this.name);
        Portability.retainLocal(popName);
        Portability.retainElement(node);
    }

    StackNode(@NsUri String ns, ElementName elementName, T node, @Local String popName, boolean scoping) {
        this.group = elementName.group;
        this.name = elementName.name;
        this.popName = popName;
        this.ns = ns;
        this.node = node;
        this.scoping = scoping;
        this.special = false;
        this.fosterParenting = false;
        this.refcount = 1;
        Portability.retainLocal(this.name);
        Portability.retainLocal(popName);
        Portability.retainElement(node);
    }

    private void destructor() {
        Portability.releaseLocal(this.name);
        Portability.releaseLocal(this.popName);
        Portability.releaseElement(this.node);
    }

    @Local
    public String toString() {
        return this.name;
    }

    public void retain() {
        ++this.refcount;
    }

    public void release() {
        --this.refcount;
        if (this.refcount == 0) {
            Portability.delete(this);
        }
    }
}

