/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;

public final class DeployerType {
    public static final DeployerType INSTALLED = new DeployerType("installed");
    public static final DeployerType REMOTE = new DeployerType("remote");
    public static final DeployerType EMBEDDED = new DeployerType("embedded");
    private String type;

    private DeployerType(String type) {
        this.type = type;
    }

    public static DeployerType toType(String typeAsString) {
        DeployerType type = typeAsString.equalsIgnoreCase(DeployerType.INSTALLED.type) ? INSTALLED : (typeAsString.equalsIgnoreCase(DeployerType.REMOTE.type) ? REMOTE : (typeAsString.equalsIgnoreCase(DeployerType.EMBEDDED.type) ? EMBEDDED : new DeployerType(typeAsString)));
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public static DeployerType toType(ContainerType containerType) {
        void var1_1;
        DeployerType type;
        if (containerType == ContainerType.EMBEDDED) {
            type = EMBEDDED;
        } else if (containerType == ContainerType.INSTALLED) {
            type = INSTALLED;
        } else if (containerType == ContainerType.REMOTE) {
            type = REMOTE;
        } else {
            throw new ContainerException("Cannot find a deployer matching container type [" + containerType + "]");
        }
        return var1_1;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof DeployerType) {
            DeployerType type = (DeployerType)object;
            if (type.type.equalsIgnoreCase(this.type)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public boolean isLocal() {
        return this == INSTALLED || this == EMBEDDED;
    }

    public boolean isRemote() {
        return this == REMOTE;
    }
}

