/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.jboss.internal.JBossContainerCapability;
import org.codehaus.cargo.container.jboss.internal.JBossInstalledLocalContainer;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractJBossInstalledLocalContainer
extends AbstractInstalledLocalContainer
implements JBossInstalledLocalContainer {
    private ContainerCapability capability = new JBossContainerCapability();
    private String version;

    public AbstractJBossInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected void doStart(Java java) throws Exception {
        java.addSysproperty(this.getAntUtils().createSysProperty("java.endorsed.dirs", new File(this.getHome(), "/lib/endorsed")));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.home.dir", this.getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.home.dir", this.getConfiguration().getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.home.url", new File(this.getConfiguration().getHome()).toURL().toString()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.name", this.getId()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.lib.url", new File(this.getLibDir(this.getConfiguration().getPropertyValue("cargo.jboss.configuration"))).toURL().toString()));
        java.createJvmarg().setValue("-Xms128m");
        java.createJvmarg().setValue("-Xmx512m");
        java.createArg().setValue("--configuration=" + this.getId());
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "bin/run.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.jboss.Main");
        AntContainerExecutorThread jbossRunner = new AntContainerExecutorThread(java);
        jbossRunner.start();
    }

    protected void doStop(Java java) throws Exception {
        Path classPath = java.createClasspath();
        classPath.createPathElement().setLocation(new File(this.getHome(), "bin/shutdown.jar"));
        java.setClassname("org.jboss.Shutdown");
        java.createArg().setValue("--server=" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        AntContainerExecutorThread jbossRunner = new AntContainerExecutorThread(java);
        jbossRunner.start();
        Thread.sleep(2000L);
    }

    protected final void verify() {
        super.verify();
        this.verifyJBossHome();
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile jarFile = new JarFile(new File(this.getHome(), "bin/run.jar"));
                ZipEntry entry = jarFile.getEntry("org/jboss/version.properties");
                if (entry != null) {
                    Properties properties = new Properties();
                    properties.load(jarFile.getInputStream(entry));
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(properties.getProperty("version.major"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.minor"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.revision"));
                    version = buffer.toString();
                } else {
                    version = defaultVersion;
                    this.getLogger().debug("Couldn't find version.properties in " + jarFile.getName(), this.getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().info("Parsed JBoss version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    public String getConfDir(String configurationName) {
        return this.getSpecificConfigurationDir("conf", configurationName);
    }

    public String getLibDir(String configurationName) {
        return this.getSpecificConfigurationDir("lib", configurationName);
    }

    public String getDeployDir(String configurationName) {
        return this.getSpecificConfigurationDir("deploy", configurationName);
    }

    private String getSpecificConfigurationDir(String location, String configurationName) {
        return this.getFileHandler().append(this.getHome(), "server/" + configurationName + "/" + location);
    }

    protected void verifyJBossHome() {
        ArrayList<String> requiredDirs = new ArrayList<String>();
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "bin"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "client"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "lib"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "lib/endorsed"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "server"));
        String errorPrefix = "Invalid JBoss installation. ";
        String errorSuffix = "Make sure the JBoss container home directory you have specified points to the right location (It's currently pointing to [" + this.getHome() + "])";
        Iterator it = requiredDirs.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            if (!this.getFileHandler().exists(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] directory doesn't exist. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectory(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] path should be a directory. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectoryEmpty(dir)) continue;
            throw new ContainerException(errorPrefix + "The [" + dir + "] directory is empty and it shouldn't be. " + errorSuffix);
        }
        String[] requiredJars = new String[]{"bin/run.jar", "bin/shutdown.jar"};
        for (int i = 0; i < requiredJars.length; ++i) {
            String jarFile = this.getFileHandler().append(this.getHome(), requiredJars[i]);
            if (this.getFileHandler().exists(jarFile)) continue;
            throw new ContainerException(errorPrefix + "The [" + jarFile + "] JAR doesn't exist. " + errorSuffix);
        }
    }
}

