/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.spi.configuration.ContainerConfiguration;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractConfiguration
extends LoggedObject
implements ContainerConfiguration,
Configuration {
    private Map properties = new HashMap();

    public AbstractConfiguration() {
        this.setProperty("cargo.protocol", "http");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "8080");
    }

    public void setProperty(String name, String value) {
        this.getLogger().debug("Setting property [" + name + "] = [" + value + "]", this.getClass().getName());
        this.properties.put(name, value);
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String name) {
        return (String)this.properties.get(name);
    }

    public void verify() {
        this.verifyServletPortProperty();
    }

    private void verifyServletPortProperty() {
        try {
            Integer.parseInt(this.getPropertyValue("cargo.servlet.port"));
        }
        catch (NumberFormatException e) {
            throw new ContainerException("Invalid port number [" + this.getPropertyValue("cargo.servlet.port") + "]. The port value must be an integer", e);
        }
    }
}

