/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;

public class WebLogicStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();

    public WebLogicStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createWebLogicFilterChain();
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/config.xml", new File(this.getHome(), "config.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/DefaultAuthenticatorInit.ldift", new File(this.getHome(), "DefaultAuthenticatorInit.ldift"), filterChain);
        this.setupDeployables(container);
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        StringBuffer appTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            String context = ((WAR)deployable).getContext();
            appTokenValue.append("<Application ");
            appTokenValue.append("Name=\"_" + context + "_app\" ");
            appTokenValue.append("Path=\"" + this.getFileHandler().getParent(deployable.getFile()) + "\" ");
            appTokenValue.append("StagedTargets=\"server\" StagingMode=\"stage\" TwoPhase=\"true\"");
            appTokenValue.append(">");
            appTokenValue.append("<WebAppComponent ");
            appTokenValue.append("Name=\"" + context + "\" ");
            appTokenValue.append("Targets=\"server\" ");
            appTokenValue.append("URI=\"" + context + "\"");
            appTokenValue.append("/></Application>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "weblogic.apps", appTokenValue.toString());
        return filterChain;
    }

    protected void setupDeployables(Container container) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            String appDir = this.getFileHandler().createDirectory(this.getHome(), "applications");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), this.getFileHandler().append(appDir, this.getFileHandler().getName(deployable.getFile())), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + container.getName() + " [" + this.getHome() + "] domain directory", e);
        }
    }

    public String toString() {
        return "WebLogic Standalone Configuration";
    }
}

