/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.internal.util.xml;

import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.cargo.module.internal.util.xml.AbstractElement;
import org.codehaus.cargo.module.internal.util.xml.AbstractNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNodeList
implements NodeList {
    protected NodeList nodeList;
    protected Element rootElement;

    public AbstractNodeList(Element rootElement, NodeList nodeList) {
        this.rootElement = rootElement;
        this.nodeList = nodeList;
    }

    public abstract Node item(int var1);

    public int getLength() {
        return this.nodeList.getLength();
    }

    public Iterator iterator() {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < this.nodeList.getLength(); ++i) {
            elements.add(this.item(i));
        }
        return elements.iterator();
    }

    public AbstractElement getByElementId(String name) {
        for (int i = 0; i < this.getLength(); ++i) {
            AbstractElement sp = (AbstractElement)this.item(i);
            if (!sp.getElementId().equals(name)) continue;
            return sp;
        }
        return null;
    }

    public void add(Element item) {
        Node n = this.rootElement.getOwnerDocument().importNode(item, true);
        if (this.getLength() == 0) {
            this.rootElement.appendChild(n);
        } else {
            AbstractNode an = (AbstractNode)this.item(this.getLength() - 1);
            this.rootElement.insertBefore(n, an.getNode());
        }
    }

    public void remove(Element item) {
        Element itemToRemove = item;
        if (item instanceof AbstractNode) {
            itemToRemove = (Element)((AbstractNode)((Object)item)).getNode();
        }
        this.rootElement.removeChild(itemToRemove);
    }
}

