/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.WebXmlMerger;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.JarUtils;
import org.xml.sax.SAXException;

public class WarArchiveMerger
implements MergeProcessor {
    private MergedWarArchive result = new MergedWarArchive();

    public void addMergeProcessor(String path, MergeProcessor merger) {
        this.result.addProcessor(path, merger);
    }

    public void addMergeItem(Object mergeItem) throws MergeException {
        if (!(mergeItem instanceof DefaultWarArchive)) {
            throw new MergeException("WarArchiveMerger cannot merge things that are not WarArchives");
        }
        this.result.add((DefaultWarArchive)mergeItem);
    }

    public Object performMerge() {
        MergedWarArchive merge = this.result;
        this.result = new MergedWarArchive();
        return merge;
    }

    public WebXmlMerger getWebXmlMerger() throws IOException, SAXException, ParserConfigurationException {
        return this.result.getWebXmlMerger();
    }

    public class MergedWarArchive
    implements WarArchive {
        private List warFiles = new ArrayList();
        private WebXml mergedWebXml;
        private List mergeProcessors = new ArrayList();
        private WebXmlMerger webXmlMerger;

        MergedWarArchive() {
        }

        protected DefaultWarArchive firstWarFile() {
            return (DefaultWarArchive)this.warFiles.get(0);
        }

        public void addProcessor(String path, MergeProcessor merger) {
            this.mergeProcessors.add(new ArchiveResourceMerger(path, merger));
        }

        void add(DefaultWarArchive warFile) {
            this.warFiles.add(warFile);
        }

        public WebXmlMerger getWebXmlMerger() throws IOException, SAXException, ParserConfigurationException {
            if (this.webXmlMerger == null) {
                this.webXmlMerger = new WebXmlMerger(this.firstWarFile().getWebXml());
            }
            return this.webXmlMerger;
        }

        public WebXml getWebXml() throws IOException, SAXException, ParserConfigurationException {
            if (this.mergedWebXml == null) {
                WebXmlMerger wxm = this.getWebXmlMerger();
                for (int i = 1; i < this.warFiles.size(); ++i) {
                    WarArchive wa = (WarArchive)this.warFiles.get(i);
                    wxm.merge(wa.getWebXml());
                }
                this.mergedWebXml = this.firstWarFile().getWebXml();
            }
            return this.mergedWebXml;
        }

        protected void executeMergeProcessors(File assembleDir) throws MergeException, IOException {
            Iterator i = this.mergeProcessors.iterator();
            while (i.hasNext()) {
                ArchiveResourceMerger processor = (ArchiveResourceMerger)i.next();
                for (int j = 0; j < this.warFiles.size(); ++j) {
                    WarArchive wa = (WarArchive)this.warFiles.get(j);
                    processor.addMergeItem(wa);
                }
                processor.execute(assembleDir);
            }
        }

        public void store(File warFile) throws MergeException, IOException, SAXException, ParserConfigurationException {
            DefaultFileHandler fileHandler = new DefaultFileHandler();
            WebXml mergedWebXml = this.getWebXml();
            String assembleDir = fileHandler.createUniqueTmpDirectory();
            this.expandToPath(assembleDir);
            WebXmlIo.writeAll(mergedWebXml, fileHandler.append(new File(assembleDir).getAbsolutePath(), File.separator + "WEB-INF"));
            this.executeMergeProcessors(new File(assembleDir));
            JarUtils jarUtils = new JarUtils();
            jarUtils.createJarFromDirectory(assembleDir, warFile);
            fileHandler.delete(assembleDir);
        }

        public boolean containsClass(String theClassName) throws IOException {
            Iterator i = this.warFiles.iterator();
            while (i.hasNext()) {
                WarArchive wa = (WarArchive)i.next();
                if (!wa.containsClass(theClassName)) continue;
                return true;
            }
            return false;
        }

        public String findResource(String theName) throws IOException {
            Iterator i = this.warFiles.iterator();
            while (i.hasNext()) {
                WarArchive wa = (WarArchive)i.next();
                String res = wa.findResource(theName);
                if (res == null) continue;
                return res;
            }
            return null;
        }

        public InputStream getResource(String thePath) throws IOException {
            Iterator i = this.warFiles.iterator();
            while (i.hasNext()) {
                WarArchive wa = (WarArchive)i.next();
                InputStream is = wa.getResource(thePath);
                if (is == null) continue;
                return is;
            }
            return null;
        }

        public List getResources(String thePath) throws IOException {
            ArrayList results = new ArrayList();
            Iterator i = this.warFiles.iterator();
            while (i.hasNext()) {
                WarArchive wa = (WarArchive)i.next();
                results.addAll(wa.getResources(thePath));
            }
            return results;
        }

        public void expandToPath(String path) throws IOException {
            for (int i = 0; i < this.warFiles.size(); ++i) {
                WarArchive wa = (WarArchive)this.warFiles.get(i);
                wa.expandToPath(path);
            }
        }

        public class ArchiveResourceMerger {
            private MergeProcessor next;
            private String resource;

            public ArchiveResourceMerger(String resource, MergeProcessor next) {
                this.next = next;
                this.resource = resource;
            }

            public void addMergeItem(Object mergeItem) throws MergeException {
                try {
                    JarArchive jar = (JarArchive)mergeItem;
                    InputStream is = jar.getResource(this.resource);
                    if (is != null) {
                        this.next.addMergeItem(is);
                    }
                }
                catch (Exception ex) {
                    throw new MergeException("Problem when fetching merge item from War Archive", ex);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(File assembleDir) throws MergeException {
                InputStream is = (InputStream)this.next.performMerge();
                if (is == null) {
                    return;
                }
                File outputFile = new File(assembleDir.getAbsolutePath() + File.separator + this.resource);
                FileOutputStream fos = null;
                try {
                    try {
                        int count;
                        fos = new FileOutputStream(outputFile);
                        byte[] buffer = new byte[1024];
                        while ((count = is.read(buffer)) > 0) {
                            fos.write(buffer, 0, count);
                        }
                        Object var8_8 = null;
                    }
                    catch (Exception e) {
                        throw new MergeException("Problem executing merge", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new MergeException("Problem when closing files used in merge", e);
                    }
                }
                try {}
                catch (Exception e) {
                    throw new MergeException("Problem when closing files used in merge", e);
                }
                if (is != null) {
                    is.close();
                }
                if (fos == null) return;
                fos.close();
            }
        }
    }
}

