/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.resin;

import org.codehaus.cargo.module.internal.util.xml.AbstractNodeList;
import org.codehaus.cargo.module.merge.AbstractMergeSet;
import org.codehaus.cargo.module.merge.MergeElement;
import org.codehaus.cargo.module.merge.MergeNodeList;
import org.codehaus.cargo.module.merge.strategy.MergeStrategy;
import org.codehaus.cargo.module.webapp.resin.ResinWebXml;
import org.codehaus.cargo.util.log.LoggedObject;

public class ResinWebXmlMerger
extends LoggedObject {
    public MergeStrategy mergeDirectoryServletStrategy = MergeStrategy.OVERWRITE;
    public MergeStrategy mergeSessionConfigStrategy = MergeStrategy.OVERWRITE;
    public MergeStrategy mergeResourceRefsStrategy = MergeStrategy.OVERWRITE;
    public MergeStrategy mergeJndiLinksStrategy = MergeStrategy.OVERWRITE;
    public MergeStrategy mergeSystemPropertiesStrategy = MergeStrategy.OVERWRITE;
    private ResinWebXml webXml;

    public ResinWebXmlMerger(ResinWebXml theWebXml) {
        if (theWebXml == null) {
            throw new IllegalArgumentException("Must pass a resin web xml");
        }
        this.webXml = theWebXml;
    }

    public final void merge(ResinWebXml theMergeWebXml) {
        if (theMergeWebXml == null) {
            throw new IllegalArgumentException("Must pass a resin web xml");
        }
        this.mergeSystemProperties(theMergeWebXml);
        this.mergeResourceRefs(theMergeWebXml);
        this.mergeJndiLinks(theMergeWebXml);
        this.mergeSessionConfig(theMergeWebXml);
        this.mergeDirectoryServlet(theMergeWebXml);
    }

    private void mergeDirectoryServlet(ResinWebXml theWebXml) {
        MergeElement merger = new MergeElement(this.webXml.getRootElement(), this.webXml.getDirectoryServlet(), theWebXml.getDirectoryServlet());
        int count = merger.merge(this.mergeDirectoryServletStrategy);
        this.getLogger().debug("Merged " + count + " directory-servlet definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    private void mergeSessionConfig(ResinWebXml theWebXml) {
        MergeElement merger = new MergeElement(this.webXml.getRootElement(), this.webXml.getSessionConfig(), theWebXml.getSessionConfig());
        int count = merger.merge(this.mergeSessionConfigStrategy);
        this.getLogger().debug("Merged " + count + " session-config definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    private void mergeResourceRefs(ResinWebXml theWebXml) {
        AbstractNodeList ourItems = this.webXml.getResourceRefs();
        AbstractNodeList mergeItems = theWebXml.getResourceRefs();
        AbstractMergeSet merger = MergeNodeList.createFromNames(ourItems, mergeItems);
        int count = merger.merge(this.mergeResourceRefsStrategy);
        this.getLogger().debug("Merged " + count + " resource-ref definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    private void mergeJndiLinks(ResinWebXml theWebXml) {
        AbstractNodeList ourItems = this.webXml.getJndiLinks();
        AbstractNodeList mergeItems = theWebXml.getJndiLinks();
        AbstractMergeSet merger = MergeNodeList.createFromNames(ourItems, mergeItems);
        int count = merger.merge(this.mergeJndiLinksStrategy);
        this.getLogger().debug("Merged " + count + " jndi-link definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    private void mergeSystemProperties(ResinWebXml theWebXml) {
        AbstractNodeList ourSystemProperties = this.webXml.getSystemProperties();
        AbstractNodeList mergeSystemProperties = theWebXml.getSystemProperties();
        AbstractMergeSet merger = MergeNodeList.createFromNames(ourSystemProperties, mergeSystemProperties);
        int count = merger.merge(this.mergeSystemPropertiesStrategy);
        this.getLogger().debug("Merged " + count + " system-property definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }
}

