/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb.weblogic;

import java.util.Iterator;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.ejb.EjbDef;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.codehaus.cargo.module.ejb.weblogic.WeblogicEjbJarXmlTag;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WeblogicEjbJarXml
extends AbstractDescriptor
implements VendorEjbDescriptor {
    public WeblogicEjbJarXml(Document document) {
        super(document, new Dtd("http://www.bea.com/servers/wls810/dtd/weblogic-ejb-jar.dtd"));
    }

    public String getFileName() {
        return "weblogic-ejb-jar.xml";
    }

    public String getJndiName(EjbDef ejb) {
        String jndiName = null;
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement != null && (jndiName = this.getNestedText(ejbElement, WeblogicEjbJarXmlTag.LOCAL_JNDI_NAME)) == null) {
            jndiName = this.getNestedText(ejbElement, WeblogicEjbJarXmlTag.JNDI_NAME);
        }
        return jndiName;
    }

    public void addDispatchPolicy(EjbDef ejb, String policy) {
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement == null) {
            throw new IllegalArgumentException("No ejb named " + ejb.getName() + " found.");
        }
        ejbElement.appendChild(this.createNestedText(WeblogicEjbJarXmlTag.DISPATCH_POLICY, policy));
    }

    public String getDispatchPolicy(EjbDef ejb) {
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement == null) {
            throw new IllegalArgumentException("No ejb named " + ejb.getName() + " found.");
        }
        String policy = this.getNestedText(ejbElement, WeblogicEjbJarXmlTag.DISPATCH_POLICY);
        return policy;
    }

    private Element getEjb(String ejbName) {
        Element ejbElement = null;
        Iterator names = this.getElements(WeblogicEjbJarXmlTag.EJB_NAME);
        while (names.hasNext()) {
            Element nameElement = (Element)names.next();
            String name = nameElement.getFirstChild().getNodeValue();
            if (!ejbName.equals(name)) continue;
            ejbElement = (Element)nameElement.getParentNode();
            break;
        }
        return ejbElement;
    }
}

