/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BasicStatusManagerTest {
    BasicStatusManager bsm = new BasicStatusManager();

    @Test
    public void smoke() {
        this.bsm.add((Status)new ErrorStatus("hello", (Object)this));
        Assertions.assertEquals((int)2, (int)this.bsm.getLevel());
        List statusList = this.bsm.getCopyOfStatusList();
        Assertions.assertNotNull((Object)statusList);
        Assertions.assertEquals((int)1, (int)statusList.size());
        Assertions.assertEquals((Object)"hello", (Object)((Status)statusList.get(0)).getMessage());
    }

    @Test
    public void many() {
        int margin = 300;
        int len = 300 + margin;
        ArrayList<Status> witness = new ArrayList<Status>();
        for (int i = 0; i < len; ++i) {
            ErrorStatus s = new ErrorStatus("" + i, (Object)this);
            this.bsm.add((Status)s);
            if (i < 150) {
                witness.add((Status)s);
            }
            if (i < 150 + margin) continue;
            witness.add((Status)s);
        }
        List statusList = this.bsm.getCopyOfStatusList();
        Assertions.assertNotNull((Object)statusList);
        Assertions.assertEquals((int)300, (int)statusList.size());
        this.arrayDiff(witness, statusList);
    }

    private void arrayDiff(List<Status> witness, List<Status> otherList) {
        int witnessSize = witness.size();
        int otherSize = otherList.size();
        boolean diff = false;
        for (int i = 0; i < witness.size(); ++i) {
            Status o;
            Status w = witness.get(i);
            if (w.equals((Object)(o = otherList.get(i)))) continue;
            System.out.println("at " + i + " differs w.message=" + w.getMessage() + " and o.message=" + o.getMessage());
            String diffMsg = StatusUtil.diff((Status)w, (Status)o);
            System.out.println(diffMsg);
            diff = true;
        }
        Assertions.assertEquals((int)witnessSize, (int)otherSize, (String)("witnessSize=" + witnessSize + " does not match resultSize=" + otherSize));
        Assertions.assertFalse((boolean)diff, (String)"diff detected");
    }

    @Test
    public void duplicateInstallationsOfOnConsoleListener() {
        OnConsoleStatusListener sl0 = new OnConsoleStatusListener();
        sl0.start();
        OnConsoleStatusListener sl1 = new OnConsoleStatusListener();
        sl1.start();
        Assertions.assertTrue((boolean)this.bsm.add((StatusListener)sl0));
        List listeners = this.bsm.getCopyOfStatusListenerList();
        Assertions.assertEquals((int)1, (int)listeners.size());
        Assertions.assertFalse((boolean)this.bsm.add((StatusListener)sl1));
        listeners = this.bsm.getCopyOfStatusListenerList();
        Assertions.assertEquals((int)1, (int)listeners.size());
    }
}

