/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event.stax;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.stax.BodyEvent;
import ch.qos.logback.core.joran.event.stax.StartEvent;
import ch.qos.logback.core.joran.event.stax.StaxEvent;
import ch.qos.logback.core.joran.event.stax.StaxEventRecorder;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.events.Attribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StaxEventRecorderTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);

    public List<StaxEvent> doTest(String filename) throws Exception {
        StaxEventRecorder recorder = new StaxEventRecorder(this.context);
        FileInputStream fis = new FileInputStream("src/test/input/joran/" + filename);
        recorder.recordEvents((InputStream)fis);
        return recorder.getEventList();
    }

    public void dump(List<StaxEvent> seList) {
        for (StaxEvent se : seList) {
            System.out.println(se);
        }
    }

    @Test
    public void testParsingOfXMLWithAttributesAndBodyText() throws Exception {
        List<StaxEvent> seList = this.doTest("event1.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)11, (int)seList.size());
        Assertions.assertEquals((Object)"test", (Object)seList.get(0).getName());
        Assertions.assertEquals((Object)"badBegin", (Object)seList.get(1).getName());
        StartEvent startEvent = (StartEvent)seList.get(7);
        Assertions.assertEquals((Object)"John Doe", (Object)startEvent.getAttributeByName("name").getValue());
        Assertions.assertEquals((Object)"XXX&", (Object)((BodyEvent)seList.get(8)).getText());
    }

    @Test
    public void testProcessingOfTextWithEntityCharacters() throws Exception {
        List<StaxEvent> seList = this.doTest("ampEvent.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"xxx & yyy", (Object)be.getText());
    }

    @Test
    public void testAttributeProcessing() throws Exception {
        List<StaxEvent> seList = this.doTest("inc.xml");
        Assertions.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)seList.size());
        StartEvent se = (StartEvent)seList.get(1);
        Attribute attr = se.getAttributeByName("increment");
        Assertions.assertNotNull((Object)attr);
        Assertions.assertEquals((Object)"1", (Object)attr.getValue());
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<StaxEvent> seList = this.doTest("spacesAndQuotes.xml");
        Assertions.assertEquals((int)3, (int)seList.size());
        BodyEvent be = (BodyEvent)seList.get(1);
        Assertions.assertEquals((Object)"[x][x] \"xyz\"%n", (Object)be.getText());
    }
}

