/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.FormatInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormatInfoTest {
    @Test
    public void testEndingInDot() {
        try {
            FormatInfo.valueOf((String)"45.");
            Assertions.fail((String)"45. is not a valid format info string");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() {
        FormatInfo fi = FormatInfo.valueOf((String)"45");
        FormatInfo witness = new FormatInfo();
        witness.setMin(45);
        Assertions.assertEquals((Object)witness, (Object)fi);
        fi = FormatInfo.valueOf((String)"4.5");
        witness = new FormatInfo();
        witness.setMin(4);
        witness.setMax(5);
        Assertions.assertEquals((Object)witness, (Object)fi);
    }

    @Test
    public void testRightPad() {
        FormatInfo fi = FormatInfo.valueOf((String)"-40");
        FormatInfo witness = new FormatInfo();
        witness.setMin(40);
        witness.setLeftPad(false);
        Assertions.assertEquals((Object)witness, (Object)fi);
        fi = FormatInfo.valueOf((String)"-12.5");
        witness = new FormatInfo();
        witness.setMin(12);
        witness.setMax(5);
        witness.setLeftPad(false);
        Assertions.assertEquals((Object)witness, (Object)fi);
        fi = FormatInfo.valueOf((String)"-14.-5");
        witness = new FormatInfo();
        witness.setMin(14);
        witness.setMax(5);
        witness.setLeftPad(false);
        witness.setLeftTruncate(false);
        Assertions.assertEquals((Object)witness, (Object)fi);
    }

    @Test
    public void testMinOnly() {
        FormatInfo fi = FormatInfo.valueOf((String)"49");
        FormatInfo witness = new FormatInfo();
        witness.setMin(49);
        Assertions.assertEquals((Object)witness, (Object)fi);
        fi = FormatInfo.valueOf((String)"-587");
        witness = new FormatInfo();
        witness.setMin(587);
        witness.setLeftPad(false);
        Assertions.assertEquals((Object)witness, (Object)fi);
    }

    @Test
    public void testMaxOnly() {
        FormatInfo fi = FormatInfo.valueOf((String)".49");
        FormatInfo witness = new FormatInfo();
        witness.setMax(49);
        Assertions.assertEquals((Object)witness, (Object)fi);
        fi = FormatInfo.valueOf((String)".-5");
        witness = new FormatInfo();
        witness.setMax(5);
        witness.setLeftTruncate(false);
        Assertions.assertEquals((Object)witness, (Object)fi);
    }
}

